var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
import { getFragmentQueryDocument } from '../queries/getFromAST';
import { getDataWithOptimisticResults } from '../optimistic-data/store';
import { readQueryFromStore } from './readFromStore';
import { writeResultToStore } from './writeToStore';
;
var ReduxDataProxy = (function () {
    function ReduxDataProxy(store, reduxRootSelector) {
        this.store = store;
        this.reduxRootSelector = reduxRootSelector;
    }
    ReduxDataProxy.prototype.readQuery = function (_a) {
        var query = _a.query, variables = _a.variables;
        return readQueryFromStore({
            rootId: 'ROOT_QUERY',
            store: getDataWithOptimisticResults(this.reduxRootSelector(this.store.getState())),
            query: query,
            variables: variables,
        });
    };
    ReduxDataProxy.prototype.readFragment = function (_a) {
        var id = _a.id, fragment = _a.fragment, fragmentName = _a.fragmentName, variables = _a.variables;
        var query = getFragmentQueryDocument(fragment, fragmentName);
        var data = getDataWithOptimisticResults(this.reduxRootSelector(this.store.getState()));
        if (typeof data[id] === 'undefined') {
            return null;
        }
        return readQueryFromStore({
            rootId: id,
            store: data,
            query: query,
            variables: variables,
        });
    };
    ReduxDataProxy.prototype.writeQuery = function (_a) {
        var data = _a.data, query = _a.query, variables = _a.variables;
        this.store.dispatch({
            type: 'APOLLO_WRITE',
            writes: [{
                    rootId: 'ROOT_QUERY',
                    result: data,
                    document: query,
                    variables: variables || {},
                }],
        });
    };
    ReduxDataProxy.prototype.writeFragment = function (_a) {
        var data = _a.data, id = _a.id, fragment = _a.fragment, fragmentName = _a.fragmentName, variables = _a.variables;
        this.store.dispatch({
            type: 'APOLLO_WRITE',
            writes: [{
                    rootId: id,
                    result: data,
                    document: getFragmentQueryDocument(fragment, fragmentName),
                    variables: variables || {},
                }],
        });
    };
    return ReduxDataProxy;
}());
export { ReduxDataProxy };
var TransactionDataProxy = (function () {
    function TransactionDataProxy(data, dataIdFromObject) {
        if (dataIdFromObject === void 0) { dataIdFromObject = function () { return null; }; }
        this.data = __assign({}, data);
        this.dataIdFromObject = dataIdFromObject;
        this.writes = [];
        this.isFinished = false;
    }
    TransactionDataProxy.prototype.finish = function () {
        this.assertNotFinished();
        var writes = this.writes;
        this.writes = [];
        this.isFinished = true;
        return writes;
    };
    TransactionDataProxy.prototype.readQuery = function (_a) {
        var query = _a.query, variables = _a.variables;
        this.assertNotFinished();
        return readQueryFromStore({
            rootId: 'ROOT_QUERY',
            store: this.data,
            query: query,
            variables: variables,
        });
    };
    TransactionDataProxy.prototype.readFragment = function (_a) {
        var id = _a.id, fragment = _a.fragment, fragmentName = _a.fragmentName, variables = _a.variables;
        this.assertNotFinished();
        var data = this.data;
        var query = getFragmentQueryDocument(fragment, fragmentName);
        if (typeof data[id] === 'undefined') {
            return null;
        }
        return readQueryFromStore({
            rootId: id,
            store: data,
            query: query,
            variables: variables,
        });
    };
    TransactionDataProxy.prototype.writeQuery = function (_a) {
        var data = _a.data, query = _a.query, variables = _a.variables;
        this.assertNotFinished();
        this.applyWrite({
            rootId: 'ROOT_QUERY',
            result: data,
            document: query,
            variables: variables || {},
        });
    };
    TransactionDataProxy.prototype.writeFragment = function (_a) {
        var data = _a.data, id = _a.id, fragment = _a.fragment, fragmentName = _a.fragmentName, variables = _a.variables;
        this.assertNotFinished();
        this.applyWrite({
            rootId: id,
            result: data,
            document: getFragmentQueryDocument(fragment, fragmentName),
            variables: variables || {},
        });
    };
    TransactionDataProxy.prototype.assertNotFinished = function () {
        if (this.isFinished) {
            throw new Error('Cannot call transaction methods after the transaction has finished.');
        }
    };
    TransactionDataProxy.prototype.applyWrite = function (write) {
        writeResultToStore({
            result: write.result,
            dataId: write.rootId,
            document: write.document,
            variables: write.variables,
            store: this.data,
            dataIdFromObject: this.dataIdFromObject,
        });
        this.writes.push(write);
    };
    return TransactionDataProxy;
}());
export { TransactionDataProxy };
//# sourceMappingURL=proxy.js.map