import { diffQueryAgainstStore, } from './readFromStore';
import { writeResultToStore, } from './writeToStore';
export function createStoreReducer(resultReducer, document, variables, config) {
    return function (store, action) {
        var _a = diffQueryAgainstStore({
            store: store,
            query: document,
            variables: variables,
            returnPartialData: true,
            config: config,
        }), result = _a.result, isMissing = _a.isMissing;
        if (isMissing) {
            return store;
        }
        var nextResult = resultReducer(result, action, variables);
        if (result !== nextResult) {
            return writeResultToStore({
                dataId: 'ROOT_QUERY',
                result: nextResult,
                store: store,
                document: document,
                variables: variables,
                dataIdFromObject: config.dataIdFromObject,
            });
        }
        return store;
    };
}
//# sourceMappingURL=resultReducers.js.map