import { ApolloLink, FetchResult } from 'apollo-link';
import { DocumentNode } from 'graphql';
import { Cache } from 'apollo-cache';
import { QueryScheduler } from '../scheduler/scheduler';
import { Observer, Subscription, Observable } from '../util/Observable';
import { DataStore } from '../data/store';
import { MutationStore } from '../data/mutations';
import { QueryStore } from '../data/queries';
import { QueryOptions, WatchQueryOptions, SubscriptionOptions, MutationOptions } from './watchQueryOptions';
import { ObservableQuery } from './ObservableQuery';
import { QueryListener, ApolloQueryResult, FetchType, OperationVariables } from './types';
export interface QueryInfo {
    listeners: QueryListener[];
    invalidated: boolean;
    newData: Cache.DiffResult<any> | null;
    document: DocumentNode | null;
    lastRequestId: number | null;
    observableQuery: ObservableQuery<any> | null;
    subscriptions: Subscription[];
    cancel?: (() => void);
}
export declare class QueryManager<TStore> {
    scheduler: QueryScheduler<TStore>;
    link: ApolloLink;
    mutationStore: MutationStore;
    queryStore: QueryStore;
    dataStore: DataStore<TStore>;
    private deduplicator;
    private queryDeduplication;
    private clientAwareness;
    private onBroadcast;
    private idCounter;
    private queries;
    private fetchQueryRejectFns;
    private queryIdsByName;
    constructor({ link, queryDeduplication, store, onBroadcast, ssrMode, clientAwareness, }: {
        link: ApolloLink;
        queryDeduplication?: boolean;
        store: DataStore<TStore>;
        onBroadcast?: () => void;
        ssrMode?: boolean;
        clientAwareness?: Record<string, string>;
    });
    stop(): void;
    mutate<T>({ mutation, variables, optimisticResponse, updateQueries: updateQueriesByName, refetchQueries, awaitRefetchQueries, update: updateWithProxyFn, errorPolicy, fetchPolicy, context, }: MutationOptions): Promise<FetchResult<T>>;
    fetchQuery<T>(queryId: string, options: WatchQueryOptions, fetchType?: FetchType, fetchMoreForQueryId?: string): Promise<FetchResult<T>>;
    queryListenerForObserver<T>(queryId: string, options: WatchQueryOptions, observer: Observer<ApolloQueryResult<T>>): QueryListener;
    watchQuery<T, TVariables = OperationVariables>(options: WatchQueryOptions, shouldSubscribe?: boolean): ObservableQuery<T, TVariables>;
    query<T>(options: QueryOptions): Promise<ApolloQueryResult<T>>;
    generateQueryId(): string;
    stopQueryInStore(queryId: string): void;
    addQueryListener(queryId: string, listener: QueryListener): void;
    updateQueryWatch(queryId: string, document: DocumentNode, options: WatchQueryOptions): () => void;
    addObservableQuery<T>(queryId: string, observableQuery: ObservableQuery<T>): void;
    removeObservableQuery(queryId: string): void;
    clearStore(): Promise<void>;
    resetStore(): Promise<ApolloQueryResult<any>[]>;
    reFetchObservableQueries(includeStandby?: boolean): Promise<ApolloQueryResult<any>[]>;
    startQuery<T>(queryId: string, options: WatchQueryOptions, listener: QueryListener): string;
    startGraphQLSubscription(options: SubscriptionOptions): Observable<any>;
    stopQuery(queryId: string): void;
    removeQuery(queryId: string): void;
    getCurrentQueryResult<T>(observableQuery: ObservableQuery<T>, optimistic?: boolean): {
        data: any;
        partial: boolean;
    };
    getQueryWithPreviousResult<T>(queryIdOrObservable: string | ObservableQuery<T>): {
        previousResult: any;
        variables: OperationVariables | undefined;
        document: DocumentNode;
    };
    broadcastQueries(): void;
    private getObservableQueryPromises;
    private fetchRequest;
    private refetchQueryByName;
    private generateRequestId;
    private getQuery;
    private setQuery;
    private invalidate;
    private buildOperationForLink;
}
//# sourceMappingURL=QueryManager.d.ts.map