import { ApolloLink, FetchResult, GraphQLRequest } from 'apollo-link';
import { ExecutionResult } from 'graphql';
import { ApolloCache, DataProxy } from 'apollo-cache';
import { QueryManager } from './core/QueryManager';
import { ApolloQueryResult, OperationVariables } from './core/types';
import { ObservableQuery } from './core/ObservableQuery';
import { Observable } from './util/Observable';
import { QueryBaseOptions, QueryOptions, WatchQueryOptions, SubscriptionOptions, MutationOptions, ModifiableWatchQueryOptions, MutationBaseOptions } from './core/watchQueryOptions';
import { DataStore } from './data/store';
export interface DefaultOptions {
    watchQuery?: ModifiableWatchQueryOptions;
    query?: QueryBaseOptions;
    mutate?: MutationBaseOptions;
}
export declare type ApolloClientOptions<TCacheShape> = {
    link: ApolloLink;
    cache: ApolloCache<TCacheShape>;
    ssrMode?: boolean;
    ssrForceFetchDelay?: number;
    connectToDevTools?: boolean;
    queryDeduplication?: boolean;
    defaultOptions?: DefaultOptions;
};
export default class ApolloClient<TCacheShape> implements DataProxy {
    link: ApolloLink;
    store: DataStore<TCacheShape>;
    cache: ApolloCache<TCacheShape>;
    queryManager: QueryManager<TCacheShape> | undefined;
    disableNetworkFetches: boolean;
    version: string;
    queryDeduplication: boolean;
    defaultOptions: DefaultOptions;
    private devToolsHookCb;
    private proxy;
    private ssrMode;
    private resetStoreCallbacks;
    constructor(options: ApolloClientOptions<TCacheShape>);
    watchQuery<T, TVariables = OperationVariables>(options: WatchQueryOptions<TVariables>): ObservableQuery<T>;
    query<T, TVariables = OperationVariables>(options: QueryOptions<TVariables>): Promise<ApolloQueryResult<T>>;
    mutate<T, TVariables = OperationVariables>(options: MutationOptions<T, TVariables>): Promise<FetchResult<T>>;
    subscribe<T = any, TVariables = OperationVariables>(options: SubscriptionOptions<TVariables>): Observable<T>;
    readQuery<T, TVariables = OperationVariables>(options: DataProxy.Query<TVariables>, optimistic?: boolean): T | null;
    readFragment<T, TVariables = OperationVariables>(options: DataProxy.Fragment<TVariables>, optimistic?: boolean): T | null;
    writeQuery<TData = any, TVariables = OperationVariables>(options: DataProxy.WriteQueryOptions<TData, TVariables>): void;
    writeFragment<TData = any, TVariables = OperationVariables>(options: DataProxy.WriteFragmentOptions<TData, TVariables>): void;
    writeData<TData = any>(options: DataProxy.WriteDataOptions<TData>): void;
    __actionHookForDevTools(cb: () => any): void;
    __requestRaw(payload: GraphQLRequest): Observable<ExecutionResult>;
    initQueryManager(): QueryManager<TCacheShape>;
    resetStore(): Promise<ApolloQueryResult<any>[] | null>;
    onResetStore(cb: () => Promise<any>): () => void;
    reFetchObservableQueries(includeStandby?: boolean): Promise<ApolloQueryResult<any>[]> | Promise<null>;
    extract(optimistic?: boolean): TCacheShape;
    restore(serializedState: TCacheShape): ApolloCache<TCacheShape>;
    private initProxy;
}
//# sourceMappingURL=ApolloClient.d.ts.map