import { GraphQLSchema, GraphQLType, GraphQLObjectType, GraphQLCompositeType, GraphQLInputType, GraphQLUnionType, GraphQLInterfaceType, DocumentNode, TypeNode } from "graphql";
import "../utilities/array";
export interface CompilerOptions {
    addTypename?: boolean;
    mergeInFieldsFromFragmentSpreads?: boolean;
    passthroughCustomScalars?: boolean;
    customScalarsPrefix?: string;
    namespace?: string;
    generateOperationIds?: boolean;
    exposeTypeNodes?: boolean;
}
export interface LegacyCompilerContext {
    schema: GraphQLSchema;
    operations: {
        [operationName: string]: LegacyOperation;
    };
    fragments: {
        [fragmentName: string]: LegacyFragment;
    };
    typesUsed: GraphQLType[];
    options: CompilerOptions;
    unionTypes: GraphQLUnionType[];
    interfaceTypes: Map<GraphQLInterfaceType, (GraphQLObjectType | GraphQLInterfaceType)[]>;
}
export interface LegacyOperation {
    filePath?: string;
    operationName: string;
    operationId?: string;
    operationType: string;
    rootType: GraphQLObjectType;
    variables: {
        name: string;
        type: GraphQLType;
    }[];
    source: string;
    sourceWithFragments?: string;
    fields: LegacyField[];
    fragmentSpreads?: string[];
    inlineFragments?: LegacyInlineFragment[];
    fragmentsReferenced: string[];
}
export interface LegacyFragment {
    filePath?: string;
    fragmentName: string;
    source: string;
    typeCondition: GraphQLCompositeType;
    possibleTypes: GraphQLObjectType[];
    fields: LegacyField[];
    fragmentSpreads: string[];
    inlineFragments: LegacyInlineFragment[];
}
export interface LegacyInlineFragment {
    typeCondition: GraphQLObjectType;
    possibleTypes: GraphQLObjectType[];
    fields: LegacyField[];
    fragmentSpreads: string[];
}
export interface LegacyField {
    responseName: string;
    fieldName: string;
    args?: Argument[];
    type: GraphQLType;
    typeNode?: TypeNode;
    description?: string;
    isConditional?: boolean;
    conditions?: BooleanCondition[];
    isDeprecated?: boolean;
    deprecationReason?: string;
    fields?: LegacyField[];
    fragmentSpreads?: string[];
    inlineFragments?: LegacyInlineFragment[];
}
export interface BooleanCondition {
    variableName: string;
    inverted: boolean;
}
export interface Argument {
    name: string;
    value: any;
    type?: GraphQLInputType;
}
export declare function compileToLegacyIR(schema: GraphQLSchema, document: DocumentNode, options?: CompilerOptions): LegacyCompilerContext;
//# sourceMappingURL=legacyIR.d.ts.map