"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTypeAnnotationFromGraphQLTypeFunction = void 0;
const graphql_1 = require("graphql");
const t = __importStar(require("@babel/types"));
const builtInScalarMap = {
    [graphql_1.GraphQLString.name]: t.stringTypeAnnotation(),
    [graphql_1.GraphQLInt.name]: t.numberTypeAnnotation(),
    [graphql_1.GraphQLFloat.name]: t.numberTypeAnnotation(),
    [graphql_1.GraphQLBoolean.name]: t.booleanTypeAnnotation(),
    [graphql_1.GraphQLID.name]: t.stringTypeAnnotation()
};
function createTypeAnnotationFromGraphQLTypeFunction(compilerOptions) {
    const arrayType = compilerOptions.useReadOnlyTypes
        ? "$ReadOnlyArray"
        : "Array";
    function nonNullableTypeAnnotationFromGraphQLType(type, typeName) {
        if (graphql_1.isListType(type)) {
            return t.genericTypeAnnotation(t.identifier(arrayType), t.typeParameterInstantiation([
                typeAnnotationFromGraphQLType(type.ofType, typeName)
            ]));
        }
        else if (graphql_1.isScalarType(type)) {
            const builtIn = builtInScalarMap[typeName || type.name];
            if (builtIn != null) {
                return builtIn;
            }
            else if (compilerOptions.passthroughCustomScalars) {
                return t.genericTypeAnnotation(t.identifier((compilerOptions.customScalarsPrefix || "") +
                    (typeName || type.name)));
            }
            else {
                return t.anyTypeAnnotation();
            }
        }
        else if (graphql_1.isNonNullType(type)) {
            return typeAnnotationFromGraphQLType(type.ofType, typeName);
        }
        else {
            return t.genericTypeAnnotation(t.identifier(typeName || type.name));
        }
    }
    function typeAnnotationFromGraphQLType(type, typeName) {
        if (graphql_1.isNonNullType(type)) {
            return nonNullableTypeAnnotationFromGraphQLType(type.ofType, typeName);
        }
        else {
            return t.nullableTypeAnnotation(nonNullableTypeAnnotationFromGraphQLType(type, typeName));
        }
    }
    return typeAnnotationFromGraphQLType;
}
exports.createTypeAnnotationFromGraphQLTypeFunction = createTypeAnnotationFromGraphQLTypeFunction;
//# sourceMappingURL=helpers.js.map