(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('apollo-link'), require('apollo-link-http-common')) :
    typeof define === 'function' && define.amd ? define(['exports', 'apollo-link', 'apollo-link-http-common'], factory) :
    (factory((global.apolloLink = global.apolloLink || {}, global.apolloLink.http = {}),global.apolloLink.core,global.apolloLink.httpCommon));
}(this, (function (exports,apolloLink,apolloLinkHttpCommon) { 'use strict';

    var __extends = (undefined && undefined.__extends) || (function () {
        var extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __rest = (undefined && undefined.__rest) || function (s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
                t[p[i]] = s[p[i]];
        return t;
    };
    var MESSAGE_NO_READABLE_STREAM = "Your browser does not support the ReadableStream API, which is needed to read streaming multipart HTTP responses for deferred queries.\nApollo Client will only parse the response when all the parts arrive.";
    function throwParseError() {
        throw new Error('Invalid multipart response from GraphQL server');
    }
    /**
     * Given the plaintext of a HTTP response body that follows the Multipart
     * protocol (see: https://www.w3.org/Protocols/rfc1341/7_2_Multipart.html),
     * break it up along the encapsulation boundaries and parse each patch for a
     * deferred query.
     *
     * Returns null if a part is incomplete, i.e. the length of the body does not
     * match the Content-Length header. This occurs on large payloads that get
     * transferred in multiple chunks.
     * @param plaintext
     */
    function parseMultipartHTTP(plaintext) {
        var results = [];
        // Split plaintext using encapsulation boundary
        var boundary = '\r\n---\r\n';
        var terminatingBoundary = '\r\n-----\r\n';
        var parts = plaintext.split(boundary);
        for (var _i = 0, parts_1 = parts; _i < parts_1.length; _i++) {
            var part = parts_1[_i];
            // Split part into header and body
            if (part.length) {
                var partArr = part.split('\r\n\r\n');
                if (!partArr || partArr.length !== 2) ;
                // Read the Content-Length header, which must be included in the response
                var headers = partArr[0];
                var headersArr = headers.split('\r\n');
                var contentLengthHeader = headersArr.find(function (headerLine) { return headerLine.toLowerCase().indexOf('content-length:') >= 0; });
                if (contentLengthHeader === undefined) {
                    throwParseError();
                }
                var contentLengthArr = contentLengthHeader.split(':');
                var contentLength = void 0;
                if (contentLengthArr.length === 2 &&
                    !isNaN(parseInt(contentLengthArr[1]))) {
                    contentLength = parseInt(contentLengthArr[1]);
                }
                else {
                    throwParseError();
                }
                var body = partArr[1];
                if (body && body.length) {
                    // Strip out the terminating boundary
                    body = body.replace(terminatingBoundary, '');
                    // Check that length of body matches the Content-Length
                    if (new TextEncoder().encode(body).length !== contentLength) {
                        return null;
                    }
                    results.push(JSON.parse(body));
                }
                else {
                    throwParseError();
                }
            }
        }
        return results;
    }
    var createHttpLink = function (linkOptions) {
        if (linkOptions === void 0) { linkOptions = {}; }
        var _a = linkOptions.uri, uri = _a === void 0 ? '/graphql' : _a, 
        // use default global fetch is nothing passed in
        fetcher = linkOptions.fetch, includeExtensions = linkOptions.includeExtensions, useGETForQueries = linkOptions.useGETForQueries, requestOptions = __rest(linkOptions, ["uri", "fetch", "includeExtensions", "useGETForQueries"]);
        // dev warnings to ensure fetch is present
        apolloLinkHttpCommon.checkFetcher(fetcher);
        //fetcher is set here rather than the destructuring to ensure fetch is
        //declared before referencing it. Reference in the destructuring would cause
        //a ReferenceError
        if (!fetcher) {
            fetcher = fetch;
        }
        var linkConfig = {
            http: { includeExtensions: includeExtensions },
            options: requestOptions.fetchOptions,
            credentials: requestOptions.credentials,
            headers: requestOptions.headers,
        };
        return new apolloLink.ApolloLink(function (operation) {
            var chosenURI = apolloLinkHttpCommon.selectURI(operation, uri);
            var context = operation.getContext();
            var contextConfig = {
                http: context.http,
                options: context.fetchOptions,
                credentials: context.credentials,
                headers: context.headers,
            };
            //uses fallback, link, and then context to build options
            var _a = apolloLinkHttpCommon.selectHttpOptionsAndBody(operation, apolloLinkHttpCommon.fallbackHttpConfig, linkConfig, contextConfig), options = _a.options, body = _a.body;
            var controller;
            if (!options.signal) {
                var _b = apolloLinkHttpCommon.createSignalIfSupported(), _controller = _b.controller, signal = _b.signal;
                controller = _controller;
                if (controller)
                    options.signal = signal;
            }
            // If requested, set method to GET if there are no mutations.
            var definitionIsMutation = function (d) {
                return d.kind === 'OperationDefinition' && d.operation === 'mutation';
            };
            if (useGETForQueries &&
                !operation.query.definitions.some(definitionIsMutation)) {
                options.method = 'GET';
            }
            if (options.method === 'GET') {
                var _c = rewriteURIForGET(chosenURI, body), newURI = _c.newURI, parseError = _c.parseError;
                if (parseError) {
                    return apolloLink.fromError(parseError);
                }
                chosenURI = newURI;
            }
            else {
                try {
                    options.body = apolloLinkHttpCommon.serializeFetchParameter(body, 'Payload');
                }
                catch (parseError) {
                    return apolloLink.fromError(parseError);
                }
            }
            return new apolloLink.Observable(function (observer) {
                fetcher(chosenURI, options)
                    .then(function (response) {
                    operation.setContext({ response: response });
                    return response;
                })
                    .then(function (response) {
                    // @defer uses multipart responses to stream patches over HTTP
                    if (response.status < 300 &&
                        response.headers &&
                        response.headers.get('Content-Type') &&
                        response.headers.get('Content-Type').indexOf('multipart/mixed') >= 0) {
                        if (response.body !== undefined &&
                            typeof TextDecoder !== 'undefined' &&
                            typeof TextEncoder !== 'undefined') {
                            // For the majority of browsers with support for ReadableStream and TextDecoder
                            var reader_1 = response.body.getReader();
                            var textDecoder_1 = new TextDecoder();
                            var chunkBuffer_1 = '';
                            reader_1.read().then(function sendNext(_a) {
                                var value = _a.value, done = _a.done;
                                if (!done) {
                                    var plaintext = void 0;
                                    try {
                                        plaintext = textDecoder_1.decode(value);
                                        // Read the header to get the Content-Length
                                        var parts = parseMultipartHTTP(chunkBuffer_1 + plaintext);
                                        if (parts === null) {
                                            // The part is not complete yet, add it to the buffer
                                            // and wait for the next chunk to arrive
                                            chunkBuffer_1 += plaintext;
                                        }
                                        else {
                                            chunkBuffer_1 = ''; // Reset
                                            for (var _i = 0, parts_2 = parts; _i < parts_2.length; _i++) {
                                                var part = parts_2[_i];
                                                observer.next(part);
                                            }
                                        }
                                    }
                                    catch (err) {
                                        var parseError = err;
                                        parseError.response = response;
                                        parseError.statusCode = response.status;
                                        parseError.bodyText = plaintext;
                                        throw parseError;
                                    }
                                    reader_1.read().then(sendNext);
                                }
                                else {
                                    reader_1.releaseLock();
                                    observer.complete();
                                }
                            });
                        }
                        else {
                            // Browser does not expose ReadableStreams on the response
                            console.warn(MESSAGE_NO_READABLE_STREAM);
                            response.text().then(function (plaintext) {
                                var parts = parseMultipartHTTP(plaintext);
                                for (var _i = 0, parts_3 = parts; _i < parts_3.length; _i++) {
                                    var part = parts_3[_i];
                                    observer.next(part);
                                }
                                observer.complete();
                            });
                        }
                    }
                    else {
                        return apolloLinkHttpCommon.parseAndCheckHttpResponse(operation)(response).then(function (result) {
                            // we have data and can send it to back up the link chain
                            observer.next(result);
                            observer.complete();
                        });
                    }
                })
                    .catch(function (err) {
                    // fetch was cancelled so its already been cleaned up in the unsubscribe
                    if (err.name === 'AbortError')
                        return;
                    // if it is a network error, BUT there is graphql result info
                    // fire the next observer before calling error
                    // this gives apollo-client (and react-apollo) the `graphqlErrors` and `networErrors`
                    // to pass to UI
                    // this should only happen if we *also* have data as part of the response key per
                    // the spec
                    if (err.result && err.result.errors && err.result.data) {
                        // if we dont' call next, the UI can only show networkError because AC didn't
                        // get andy graphqlErrors
                        // this is graphql execution result info (i.e errors and possibly data)
                        // this is because there is no formal spec how errors should translate to
                        // http status codes. So an auth error (401) could have both data
                        // from a public field, errors from a private field, and a status of 401
                        // {
                        //  user { // this will have errors
                        //    firstName
                        //  }
                        //  products { // this is public so will have data
                        //    cost
                        //  }
                        // }
                        //
                        // the result of above *could* look like this:
                        // {
                        //   data: { products: [{ cost: "$10" }] },
                        //   errors: [{
                        //      message: 'your session has timed out',
                        //      path: []
                        //   }]
                        // }
                        // status code of above would be a 401
                        // in the UI you want to show data where you can, errors as data where you can
                        // and use correct http status codes
                        observer.next(err.result);
                    }
                    observer.error(err);
                });
                return function () {
                    // XXX support canceling this request
                    // https://developers.google.com/web/updates/2017/09/abortable-fetch
                    if (controller)
                        controller.abort();
                };
            });
        });
    };
    // For GET operations, returns the given URI rewritten with parameters, or a
    // parse error.
    function rewriteURIForGET(chosenURI, body) {
        // Implement the standard HTTP GET serialization, plus 'extensions'. Note
        // the extra level of JSON serialization!
        var queryParams = [];
        var addQueryParam = function (key, value) {
            queryParams.push(key + "=" + encodeURIComponent(value));
        };
        if ('query' in body) {
            addQueryParam('query', body.query);
        }
        if (body.operationName) {
            addQueryParam('operationName', body.operationName);
        }
        if (body.variables) {
            var serializedVariables = void 0;
            try {
                serializedVariables = apolloLinkHttpCommon.serializeFetchParameter(body.variables, 'Variables map');
            }
            catch (parseError) {
                return { parseError: parseError };
            }
            addQueryParam('variables', serializedVariables);
        }
        if (body.extensions) {
            var serializedExtensions = void 0;
            try {
                serializedExtensions = apolloLinkHttpCommon.serializeFetchParameter(body.extensions, 'Extensions map');
            }
            catch (parseError) {
                return { parseError: parseError };
            }
            addQueryParam('extensions', serializedExtensions);
        }
        // Reconstruct the URI with added query params.
        // XXX This assumes that the URI is well-formed and that it doesn't
        //     already contain any of these query params. We could instead use the
        //     URL API and take a polyfill (whatwg-url@6) for older browsers that
        //     don't support URLSearchParams. Note that some browsers (and
        //     versions of whatwg-url) support URL but not URLSearchParams!
        var fragment = '', preFragment = chosenURI;
        var fragmentStart = chosenURI.indexOf('#');
        if (fragmentStart !== -1) {
            fragment = chosenURI.substr(fragmentStart);
            preFragment = chosenURI.substr(0, fragmentStart);
        }
        var queryParamsPrefix = preFragment.indexOf('?') === -1 ? '?' : '&';
        var newURI = preFragment + queryParamsPrefix + queryParams.join('&') + fragment;
        return { newURI: newURI };
    }
    var HttpLink = /** @class */ (function (_super) {
        __extends(HttpLink, _super);
        function HttpLink(opts) {
            return _super.call(this, createHttpLink(opts).request) || this;
        }
        return HttpLink;
    }(apolloLink.ApolloLink));

    exports.createHttpLink = createHttpLink;
    exports.HttpLink = HttpLink;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=bundle.umd.js.map
