"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var chai_1 = require("chai");
var sinon = require("sinon");
var webSocketLink_1 = require("../src/webSocketLink");
var subscriptions_transport_ws_1 = require("subscriptions-transport-ws");
var apollo_link_core_1 = require("apollo-link-core");
var apollo_link_core_2 = require("apollo-link-core");
var query = "\n  query SampleQuery {\n    stub {\n      id\n    }\n  }\n";
var mutation = "\n  mutation SampleMutation {\n    stub {\n      id\n    }\n  }\n";
var subscription = "\n  subscription SampleSubscription {\n    stub {\n      id\n    }\n  }\n";
describe('WebSocketLink', function () {
    it('constructs', function () {
        var client = {};
        client.__proto__ = subscriptions_transport_ws_1.SubscriptionClient.prototype;
        chai_1.assert.doesNotThrow(function () { return new webSocketLink_1.default(client); });
    });
    it('should call request on the client for a query', function (done) {
        var result = { data: { data: 'result' } };
        var client = {};
        var observable = apollo_link_core_1.Observable.of(result);
        client.__proto__ = subscriptions_transport_ws_1.SubscriptionClient.prototype;
        client.request = sinon.stub().returns(observable);
        var link = new webSocketLink_1.default(client);
        var obs = apollo_link_core_2.execute(link, { query: query });
        chai_1.assert.deepEqual(obs, observable);
        obs.subscribe(function (data) {
            chai_1.assert.equal(data, result);
            chai_1.assert(client.request.calledOnce);
            done();
        });
    });
    it('should call query on the client for a mutation', function (done) {
        var result = { data: { data: 'result' } };
        var client = {};
        var observable = apollo_link_core_1.Observable.of(result);
        client.__proto__ = subscriptions_transport_ws_1.SubscriptionClient.prototype;
        client.request = sinon.stub().returns(observable);
        var link = new webSocketLink_1.default(client);
        var obs = apollo_link_core_2.execute(link, { query: mutation });
        chai_1.assert.deepEqual(obs, observable);
        obs.subscribe(function (data) {
            chai_1.assert.equal(data, result);
            chai_1.assert(client.request.calledOnce);
            done();
        });
    });
    it('should call request on the subscriptions client for subscription', function (done) {
        var result = { data: { data: 'result' } };
        var client = {};
        var observable = apollo_link_core_1.Observable.of(result);
        client.__proto__ = subscriptions_transport_ws_1.SubscriptionClient.prototype;
        client.request = sinon.stub().returns(observable);
        var link = new webSocketLink_1.default(client);
        var obs = apollo_link_core_2.execute(link, { query: mutation });
        chai_1.assert.deepEqual(obs, observable);
        obs.subscribe(function (data) {
            chai_1.assert.equal(data, result);
            chai_1.assert(client.request.calledOnce);
            done();
        });
    });
    it('should call next with multiple results for subscription', function (done) {
        var results = [
            { data: { data: 'result1' } },
            { data: { data: 'result2' } },
        ];
        var client = {};
        client.__proto__ = subscriptions_transport_ws_1.SubscriptionClient.prototype;
        client.request = sinon.stub().callsFake(function () {
            var copy = results.slice();
            return new apollo_link_core_1.Observable(function (observer) {
                observer.next(copy[0]);
                observer.next(copy[1]);
            });
        });
        var link = new webSocketLink_1.default(client);
        apollo_link_core_2.execute(link, { query: subscription }).subscribe(function (data) {
            chai_1.assert(client.request.calledOnce);
            chai_1.assert.equal(data, results.shift());
            if (results.length === 0) {
                done();
            }
        });
    });
});
//# sourceMappingURL=webSocketLink.js.map