import { OptimisticDependencyFunction } from 'optimism';
import { NormalizedCache, NormalizedCacheObject, StoreObject } from './types';
declare type DependType = OptimisticDependencyFunction<string> | null;
export declare abstract class EntityCache implements NormalizedCache {
    protected data: NormalizedCacheObject;
    readonly depend: DependType;
    abstract addLayer(layerId: string, replay: (layer: EntityCache) => any): EntityCache;
    abstract removeLayer(layerId: string): EntityCache;
    toObject(): NormalizedCacheObject;
    has(dataId: string): boolean;
    get(dataId: string): StoreObject;
    set(dataId: string, value: StoreObject): void;
    delete(dataId: string): void;
    clear(): void;
    replace(newData: NormalizedCacheObject | null): void;
    private rootIds;
    retain(rootId: string): number;
    release(rootId: string): number;
    getRootIdSet(): Set<string>;
    gc(): string[];
    private refs;
    findChildRefIds(dataId: string): Record<string, true>;
}
export declare namespace EntityCache {
    class Root extends EntityCache {
        private sharedLayerDepend;
        constructor({ resultCaching, seed, }: {
            resultCaching?: boolean;
            seed?: NormalizedCacheObject;
        });
        addLayer(layerId: string, replay: (layer: EntityCache) => any): EntityCache;
        removeLayer(layerId: string): Root;
    }
}
export declare function supportsResultCaching(store: any): store is EntityCache;
export declare function defaultNormalizedCacheFactory(seed?: NormalizedCacheObject): NormalizedCache;
export {};
//# sourceMappingURL=entityCache.d.ts.map