import { InlineFragmentNode, FragmentDefinitionNode, SelectionSetNode, FieldNode } from "graphql";
import { FragmentMap } from '../../utilities/graphql/fragments';
import { StoreValue } from '../../utilities/graphql/storeUtils';
import { IdGetter, StoreObject } from "./types";
export declare type TypePolicies = {
    [__typename: string]: TypePolicy;
};
declare type KeySpecifier = (string | any[])[];
declare type KeyFieldsFunction = (this: Policies, object: Readonly<StoreObject>, context: {
    typename: string;
    selectionSet?: SelectionSetNode;
    fragmentMap?: FragmentMap;
}) => ReturnType<IdGetter>;
declare type TypePolicy = {
    keyFields?: KeySpecifier | KeyFieldsFunction | false;
    queryType?: true;
    mutationType?: true;
    subscriptionType?: true;
    fields?: {
        [fieldName: string]: FieldPolicy<StoreValue> | FieldReadFunction<StoreValue>;
    };
};
declare type KeyArgsFunction = (this: Policies, field: FieldNode, context: {
    typename: string;
    variables: Record<string, any>;
}) => ReturnType<IdGetter>;
export declare type FieldPolicy<TValue> = {
    keyArgs?: KeySpecifier | KeyArgsFunction;
    read?: FieldReadFunction<TValue>;
    merge?: FieldMergeFunction<TValue>;
};
interface FieldFunctionOptions {
    args: Record<string, any>;
    parentObject: Readonly<StoreObject>;
    field: FieldNode;
    variables?: Record<string, any>;
    toReference: Policies["toReference"];
}
interface FieldReadFunction<TExisting, TResult = TExisting> {
    (this: Policies, existing: Readonly<TExisting> | undefined, options: FieldFunctionOptions): TResult;
    call(self: Policies, existing: Readonly<TExisting> | undefined, options: FieldFunctionOptions): TResult;
}
interface FieldMergeFunction<TExisting> {
    (this: Policies, existing: Readonly<TExisting> | undefined, incoming: Readonly<StoreValue>, options: FieldFunctionOptions): TExisting;
    call(self: Policies, existing: Readonly<TExisting> | undefined, incoming: Readonly<StoreValue>, options: FieldFunctionOptions): TExisting;
}
export declare function defaultDataIdFromObject(object: StoreObject): string;
export declare type PossibleTypesMap = {
    [supertype: string]: string[];
};
export declare class Policies {
    private config;
    private typePolicies;
    readonly rootTypenamesById: Readonly<Record<string, string>>;
    readonly usingPossibleTypes = false;
    constructor(config?: {
        dataIdFromObject?: IdGetter;
        possibleTypes?: PossibleTypesMap;
        typePolicies?: TypePolicies;
    });
    toReference: (object: StoreObject, selectionSet?: SelectionSetNode, fragmentMap?: FragmentMap) => import("../../utilities/graphql/storeUtils").Reference;
    identify(object: StoreObject, selectionSet?: SelectionSetNode, fragmentMap?: FragmentMap): string | null;
    addTypePolicies(typePolicies: TypePolicies): void;
    private setRootTypename;
    addPossibleTypes(possibleTypes: PossibleTypesMap): void;
    private getTypePolicy;
    private getSubtypeSet;
    private getFieldPolicy;
    fragmentMatches(fragment: InlineFragmentNode | FragmentDefinitionNode, typename: string): boolean | "heuristic";
    getStoreFieldName(typename: string | undefined, field: FieldNode, variables: Record<string, any>): string;
    readFieldFromStoreObject(parentObject: Readonly<StoreObject>, field: FieldNode, typename?: string, variables?: Record<string, any>): StoreValue;
    getFieldMergeFunction(typename: string, field: FieldNode, variables?: Record<string, any>): StoreValueMergeFunction;
}
export declare type StoreValueMergeFunction = (existing: StoreValue, incoming: StoreValue, parentObject: Readonly<StoreObject>) => StoreValue;
export {};
//# sourceMappingURL=policies.d.ts.map