import { KeyTrie } from 'optimism';
import { Cache } from '../core/types/Cache';
import { DiffQueryAgainstStoreOptions, ReadQueryOptions, StoreObject } from './types';
import { Policies } from './policies';
export declare type VariableMap = {
    [name: string]: any;
};
export declare type ExecResultMissingField = {
    object: StoreObject;
    fieldName: string;
    tolerable: boolean;
};
export declare type ExecResult<R = any> = {
    result: R;
    missing?: ExecResultMissingField[];
};
export interface StoreReaderConfig {
    addTypename?: boolean;
    cacheKeyRoot?: KeyTrie<object>;
    policies: Policies;
}
export declare class StoreReader {
    private config;
    constructor(config: StoreReaderConfig);
    readQueryFromStore<QueryType>(options: ReadQueryOptions): QueryType | undefined;
    diffQueryAgainstStore<T>({ store, query, variables, previousResult, returnPartialData, rootId, config, }: DiffQueryAgainstStoreOptions): Cache.DiffResult<T>;
    private executeSelectionSet;
    private executeField;
    private combineExecResults;
    private executeSubSelectedArray;
}
//# sourceMappingURL=readFromStore.d.ts.map