import { DocumentNode } from 'graphql';
import { Transaction } from '../core/cache';
import { StoreValue } from '../../utilities/graphql/storeUtils';
export interface IdGetterObj extends Object {
    __typename?: string;
    id?: string;
    _id?: string;
}
export declare type IdGetter = (value: IdGetterObj) => string | null | undefined;
export interface NormalizedCache {
    has(dataId: string): boolean;
    get(dataId: string): StoreObject;
    set(dataId: string, value: StoreObject): void;
    delete(dataId: string): void;
    clear(): void;
    toObject(): NormalizedCacheObject;
    replace(newData: NormalizedCacheObject): void;
    retain(rootId: string): number;
    release(rootId: string): number;
}
export interface NormalizedCacheObject {
    [dataId: string]: StoreObject | undefined;
}
export interface StoreObject {
    __typename?: string;
    [storeFieldKey: string]: StoreValue;
}
export declare type OptimisticStoreItem = {
    id: string;
    data: NormalizedCacheObject;
    transaction: Transaction<NormalizedCacheObject>;
};
export declare type ReadQueryOptions = {
    store: NormalizedCache;
    query: DocumentNode;
    variables?: Object;
    previousResult?: any;
    rootId?: string;
    config?: ApolloReducerConfig;
};
export declare type DiffQueryAgainstStoreOptions = ReadQueryOptions & {
    returnPartialData?: boolean;
};
export declare type ApolloReducerConfig = {
    dataIdFromObject?: IdGetter;
    addTypename?: boolean;
};
export declare type CacheResolver = (rootValue: any, args: {
    [argName: string]: any;
}, context: any) => any;
export declare type CacheResolverMap = {
    [typeName: string]: {
        [fieldName: string]: CacheResolver;
    };
};
export declare type CustomResolver = CacheResolver;
export declare type CustomResolverMap = CacheResolverMap;
//# sourceMappingURL=types.d.ts.map