import { SelectionSetNode, DocumentNode } from 'graphql';
import { FragmentMap } from '../../utilities/graphql/fragments';
import { NormalizedCache, StoreObject } from './types';
import { Policies, StoreValueMergeFunction } from './policies';
export declare type WriteContext = {
    readonly store: NormalizedCache;
    readonly written: {
        [dataId: string]: SelectionSetNode[];
    };
    readonly mergeFields: StoreObjectMergeFunction;
    readonly mergeStoreObjects: StoreObjectMergeFunction;
    readonly variables?: any;
    readonly fragmentMap?: FragmentMap;
};
declare type StoreObjectMergeFunction = (existing: StoreObject, incoming: StoreObject, overrides?: MergeOverrides) => StoreObject;
declare type MergeOverrides = Record<string, {
    merge?: StoreValueMergeFunction;
    child?: MergeOverrides;
}>;
export interface StoreWriterConfig {
    policies: Policies;
}
export declare class StoreWriter {
    private policies;
    constructor(config: StoreWriterConfig);
    writeQueryToStore({ query, result, dataId, store, variables, }: {
        query: DocumentNode;
        result: Object;
        dataId?: string;
        store?: NormalizedCache;
        variables?: Object;
    }): NormalizedCache;
    private writeSelectionSetToStore;
    private processSelectionSet;
    private processFieldValue;
}
export {};
//# sourceMappingURL=writeToStore.d.ts.map