import { Observable } from '../../utilities/observables/Observable';
export function fromPromise(promise) {
    return new Observable(function (observer) {
        promise
            .then(function (value) {
            observer.next(value);
            observer.complete();
        })
            .catch(observer.error.bind(observer));
    });
}
//# sourceMappingURL=fromPromise.js.map