import { InvariantError } from 'ts-invariant';

function validateOperation(operation) {
    var OPERATION_FIELDS = [
        'query',
        'operationName',
        'variables',
        'extensions',
        'context',
    ];
    for (var _i = 0, _a = Object.keys(operation); _i < _a.length; _i++) {
        var key = _a[_i];
        if (OPERATION_FIELDS.indexOf(key) < 0) {
            throw process.env.NODE_ENV === "production" ? new InvariantError(32) : new InvariantError("illegal argument: " + key);
        }
    }
    return operation;
}

export { validateOperation };
//# sourceMappingURL=validateOperation.js.map
