import { MutationDataOptions, MutationFunctionOptions, MutationResult } from '../types/types';
import { OperationData } from './OperationData';
import { OperationVariables } from '../../core/types';
import { FetchResult } from '../../link/core/types';
export declare class MutationData<TData = any, TVariables = OperationVariables> extends OperationData {
    private mostRecentMutationId;
    private result;
    private previousResult?;
    private setResult;
    constructor({ options, context, result, setResult }: {
        options: MutationDataOptions<TData, TVariables>;
        context: any;
        result: MutationResult<TData>;
        setResult: (result: MutationResult<TData>) => any;
    });
    execute(result: MutationResult<TData>): [(options?: MutationFunctionOptions<TData, TVariables>) => Promise<FetchResult<TData, Record<string, any>, Record<string, any>>>, MutationResult<TData>];
    afterExecute(): any;
    cleanup(): void;
    private runMutation;
    private mutate;
    private onMutationStart;
    private onMutationCompleted;
    private onMutationError;
    private generateNewMutationId;
    private isMostRecentMutation;
    private updateResult;
}
//# sourceMappingURL=MutationData.d.ts.map