import { ApolloClient } from '../../ApolloClient';
import { ApolloQueryResult, OperationVariables } from '../../core/types';
import { ApolloError } from '../../errors/ApolloError';
import { FetchMoreOptions, UpdateQueryOptions } from '../../core/ObservableQuery';
import { FetchMoreQueryOptions, SubscribeToMoreOptions } from '../../core/watchQueryOptions';
import { MutationFunction, BaseQueryOptions, BaseMutationOptions, MutationResult } from '../types/types';
export interface QueryControls<TData = any, TGraphQLVariables = OperationVariables> {
    error?: ApolloError;
    networkStatus: number;
    loading: boolean;
    variables: TGraphQLVariables;
    fetchMore: (fetchMoreOptions: FetchMoreQueryOptions<TGraphQLVariables, any> & FetchMoreOptions<TData, TGraphQLVariables>) => Promise<ApolloQueryResult<TData>>;
    refetch: (variables?: TGraphQLVariables) => Promise<ApolloQueryResult<TData>>;
    startPolling: (pollInterval: number) => void;
    stopPolling: () => void;
    subscribeToMore: (options: SubscribeToMoreOptions) => () => void;
    updateQuery: (mapFn: (previousQueryResult: any, options: UpdateQueryOptions<any>) => any) => void;
}
export declare type DataValue<TData, TGraphQLVariables = OperationVariables> = QueryControls<TData, TGraphQLVariables> & Partial<TData>;
export interface DataProps<TData, TGraphQLVariables = OperationVariables> {
    data: DataValue<TData, TGraphQLVariables>;
}
export interface MutateProps<TData = any, TGraphQLVariables = OperationVariables> {
    mutate: MutationFunction<TData, TGraphQLVariables>;
    result: MutationResult<TData>;
}
export declare type ChildProps<TProps = {}, TData = {}, TGraphQLVariables = OperationVariables> = TProps & Partial<DataProps<TData, TGraphQLVariables>> & Partial<MutateProps<TData, TGraphQLVariables>>;
export declare type ChildDataProps<TProps = {}, TData = {}, TGraphQLVariables = OperationVariables> = TProps & DataProps<TData, TGraphQLVariables>;
export declare type ChildMutateProps<TProps = {}, TData = {}, TGraphQLVariables = OperationVariables> = TProps & MutateProps<TData, TGraphQLVariables>;
export interface OptionProps<TProps = any, TData = any, TGraphQLVariables = OperationVariables> extends Partial<DataProps<TData, TGraphQLVariables>>, Partial<MutateProps<TData, TGraphQLVariables>> {
    ownProps: TProps;
}
export interface OperationOption<TProps, TData, TGraphQLVariables = OperationVariables, TChildProps = ChildProps<TProps, TData, TGraphQLVariables>> {
    options?: BaseQueryOptions<TGraphQLVariables> | BaseMutationOptions<TData, TGraphQLVariables> | ((props: TProps) => BaseQueryOptions<TGraphQLVariables> | BaseMutationOptions<TData, TGraphQLVariables>);
    props?: (props: OptionProps<TProps, TData, TGraphQLVariables>, lastProps?: TChildProps | void) => TChildProps;
    skip?: boolean | ((props: TProps) => boolean);
    name?: string;
    withRef?: boolean;
    shouldResubscribe?: (props: TProps, nextProps: TProps) => boolean;
    alias?: string;
}
export declare type WithApolloClient<P> = P & {
    client?: ApolloClient<any>;
};
//# sourceMappingURL=types.d.ts.map