import { Trie } from "@wry/trie";
import { canUseWeakMap } from "../../utilities/index.js";
import { objToStr } from "./helpers.js";
var Pass = (function () {
    function Pass(value) {
        this.value = value;
    }
    return Pass;
}());
function isObjectOrArray(value) {
    return !!value && typeof value === "object";
}
var ObjectCanon = (function () {
    function ObjectCanon() {
        this.known = new (canUseWeakMap ? WeakSet : Set)();
        this.pool = new Trie(canUseWeakMap);
        this.keysByJSON = new Map();
    }
    ObjectCanon.prototype.pass = function (value) {
        return isObjectOrArray(value) ? new Pass(value) : value;
    };
    ObjectCanon.prototype.admit = function (value) {
        var _this = this;
        if (isObjectOrArray(value)) {
            if (value instanceof Pass) {
                return value.value;
            }
            switch (objToStr.call(value)) {
                case "[object Array]": {
                    if (this.known.has(value))
                        return value;
                    var array = value.map(this.admit, this);
                    var node = this.pool.lookupArray(array);
                    if (!node.array) {
                        this.known.add(node.array = array);
                        if (process.env.NODE_ENV !== "production") {
                            Object.freeze(array);
                        }
                    }
                    return node.array;
                }
                case "[object Object]": {
                    if (this.known.has(value))
                        return value;
                    var proto = Object.getPrototypeOf(value);
                    var array_1 = [proto];
                    var keys = this.sortedKeys(value);
                    array_1.push(keys.json);
                    var firstValueIndex_1 = array_1.length;
                    keys.sorted.forEach(function (key) {
                        array_1.push(_this.admit(value[key]));
                    });
                    var node = this.pool.lookupArray(array_1);
                    if (!node.object) {
                        var obj_1 = node.object = Object.create(proto);
                        this.known.add(obj_1);
                        keys.sorted.forEach(function (key, i) {
                            obj_1[key] = array_1[firstValueIndex_1 + i];
                        });
                        if (process.env.NODE_ENV !== "production") {
                            Object.freeze(obj_1);
                        }
                    }
                    return node.object;
                }
            }
        }
        return value;
    };
    ObjectCanon.prototype.sortedKeys = function (obj) {
        var keys = Object.keys(obj);
        var node = this.pool.lookupArray(keys);
        if (!node.keys) {
            keys.sort();
            var json = JSON.stringify(keys);
            if (!(node.keys = this.keysByJSON.get(json))) {
                this.keysByJSON.set(json, node.keys = { sorted: keys, json: json });
            }
        }
        return node.keys;
    };
    return ObjectCanon;
}());
export { ObjectCanon };
//# sourceMappingURL=object-canon.js.map