import { __assign } from "tslib";
import { useRef } from "react";
import equal from "@wry/equality";
export function useNormalizedOptions(optionsOrFunction) {
    var optionsRef = useRef();
    var options = optionsRef.current || Object.create(null);
    if (typeof optionsOrFunction === "function") {
        var newOptions = optionsOrFunction(options);
        if (newOptions !== options) {
            Object.assign(options, newOptions, newOptions.variables && {
                variables: __assign(__assign({}, options.variables), newOptions.variables),
            });
        }
    }
    else if (optionsOrFunction && !equal(optionsOrFunction, options)) {
        options = optionsOrFunction;
    }
    return optionsRef.current = options;
}
//# sourceMappingURL=options.js.map