import './fixPolyfills';
import { DocumentNode } from 'graphql';
import { ApolloCache } from '../core/cache';
import { Cache } from '../core/types/Cache';
import { StoreObject, Reference } from '../../utilities';
import { InMemoryCacheConfig, NormalizedCacheObject } from './types';
import { makeVar } from './reactiveVars';
import { Policies } from './policies';
declare type BroadcastOptions = Pick<Cache.BatchOptions<InMemoryCache>, "optimistic" | "onWatchUpdated">;
export declare class InMemoryCache extends ApolloCache<NormalizedCacheObject> {
    private data;
    private optimisticData;
    protected config: InMemoryCacheConfig;
    private watches;
    private addTypename;
    private typenameDocumentCache;
    private storeReader;
    private storeWriter;
    private maybeBroadcastWatch;
    readonly policies: Policies;
    readonly makeVar: typeof makeVar;
    constructor(config?: InMemoryCacheConfig);
    private init;
    private resetResultCache;
    restore(data: NormalizedCacheObject): this;
    extract(optimistic?: boolean): NormalizedCacheObject;
    read<T>(options: Cache.ReadOptions): T | null;
    write(options: Cache.WriteOptions): Reference | undefined;
    modify(options: Cache.ModifyOptions): boolean;
    diff<TData, TVariables = any>(options: Cache.DiffOptions<TData, TVariables>): Cache.DiffResult<TData>;
    watch<TData = any, TVariables = any>(watch: Cache.WatchOptions<TData, TVariables>): () => void;
    gc(options?: {
        resetResultCache?: boolean;
        resetResultIdentities?: boolean;
    }): string[];
    retain(rootId: string, optimistic?: boolean): number;
    release(rootId: string, optimistic?: boolean): number;
    identify(object: StoreObject | Reference): string | undefined;
    evict(options: Cache.EvictOptions): boolean;
    reset(options?: Cache.ResetOptions): Promise<void>;
    removeOptimistic(idToRemove: string): void;
    private txCount;
    batch<TUpdateResult>(options: Cache.BatchOptions<InMemoryCache, TUpdateResult>): TUpdateResult;
    performTransaction(update: (cache: InMemoryCache) => any, optimisticId?: string | null): any;
    transformDocument(document: DocumentNode): DocumentNode;
    protected broadcastWatches(options?: BroadcastOptions): void;
    private broadcastWatch;
}
export {};
//# sourceMappingURL=inMemoryCache.d.ts.map