import { invariant } from "../../utilities/globals/index.js";
import * as React from 'react';
import { getApolloContext } from "./ApolloContext.js";
export var ApolloProvider = function (_a) {
    var client = _a.client, children = _a.children;
    var ApolloContext = getApolloContext();
    return React.createElement(ApolloContext.Consumer, null, function (context) {
        if (context === void 0) { context = {}; }
        if (client && context.client !== client) {
            context = Object.assign({}, context, { client: client });
        }
        __DEV__ ? invariant(context.client, 'ApolloProvider was not passed a client instance. Make ' +
            'sure you pass in your client via the "client" prop.') : invariant(context.client, 26);
        return (React.createElement(ApolloContext.Provider, { value: context }, children));
    });
};
//# sourceMappingURL=ApolloProvider.js.map