import React, { useState, useRef, useEffect } from 'react';
import { E as EmbeddedExplorer } from '../EmbeddedExplorer-0d6b7742.js';
import useDeepCompareEffect from 'use-deep-compare-effect';
import 'whatwg-mimetype';
import 'zen-observable-ts';
import 'graphql-ws';
import 'subscriptions-transport-ws';

function ApolloExplorerReact(props) {
  const [wrapperElement, setWrapperElement] = useState();
  const currentEmbedRef = useRef(); // we need to default to empty objects for the objects type props
  // that show up in the useDeepCompareEffect below, because useDeepCompareEffect
  // will throw if all of its deps are primitives (undefined instead of objects)

  const {
    endpointUrl,
    handleRequest,
    initialState = {},
    persistExplorerState,
    graphRef,
    autoInviteOptions = {},
    includeCookies,
    className,
    schema
  } = props;
  useDeepCompareEffect(() => {
    var _a;

    if (!wrapperElement) return;
    (_a = currentEmbedRef.current) === null || _a === void 0 ? void 0 : _a.dispose();
    currentEmbedRef.current = new EmbeddedExplorer(Object.assign(Object.assign({}, props), {
      target: wrapperElement
    }));
    return () => {
      var _a;

      return (_a = currentEmbedRef.current) === null || _a === void 0 ? void 0 : _a.dispose();
    };
  }, // we purposely exclude schema here
  // when the schema changes we don't want to tear down and render a new embed,
  // we just want to pm the new schema to the embed in the below useEffect
  [endpointUrl, handleRequest, initialState, persistExplorerState, graphRef, autoInviteOptions, includeCookies, className, wrapperElement]);
  useEffect(() => {
    var _a;

    if (schema) (_a = currentEmbedRef.current) === null || _a === void 0 ? void 0 : _a.updateSchemaInEmbed({
      schema
    });
  }, [schema, currentEmbedRef.current]);
  return React.createElement("div", {
    className: className,
    ref: element => {
      setWrapperElement(element);
    }
  });
}

export { ApolloExplorerReact as ApolloExplorer };
