'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var EmbeddedExplorer = require('../EmbeddedExplorer.production.min.cjs');
var useDeepCompareEffect = require('use-deep-compare-effect');
require('whatwg-mimetype');
require('zen-observable-ts');
require('graphql-ws');
require('subscriptions-transport-ws');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var useDeepCompareEffect__default = /*#__PURE__*/_interopDefaultLegacy(useDeepCompareEffect);

function ApolloExplorerReact(props) {
  const [wrapperElement, setWrapperElement] = React.useState();
  const currentEmbedRef = React.useRef(); // we need to default to empty objects for the objects type props
  // that show up in the useDeepCompareEffect below, because useDeepCompareEffect
  // will throw if all of its deps are primitives (undefined instead of objects)

  const {
    endpointUrl,
    handleRequest,
    initialState = {},
    persistExplorerState,
    graphRef,
    autoInviteOptions = {},
    includeCookies,
    className,
    schema
  } = props;
  useDeepCompareEffect__default["default"](() => {
    var _a;

    if (!wrapperElement) return;
    (_a = currentEmbedRef.current) === null || _a === void 0 ? void 0 : _a.dispose();
    currentEmbedRef.current = new EmbeddedExplorer.EmbeddedExplorer(Object.assign(Object.assign({}, props), {
      target: wrapperElement
    }));
    return () => {
      var _a;

      return (_a = currentEmbedRef.current) === null || _a === void 0 ? void 0 : _a.dispose();
    };
  }, // we purposely exclude schema here
  // when the schema changes we don't want to tear down and render a new embed,
  // we just want to pm the new schema to the embed in the below useEffect
  [endpointUrl, handleRequest, initialState, persistExplorerState, graphRef, autoInviteOptions, includeCookies, className, wrapperElement]);
  React.useEffect(() => {
    var _a;

    if (schema) (_a = currentEmbedRef.current) === null || _a === void 0 ? void 0 : _a.updateSchemaInEmbed({
      schema
    });
  }, [schema, currentEmbedRef.current]);
  return React__default["default"].createElement("div", {
    className: className,
    ref: element => {
      setWrapperElement(element);
    }
  });
}

exports.ApolloExplorer = ApolloExplorerReact;
