import type { IntrospectionQuery } from 'graphql';
import { HandleRequest } from './helpers/postMessageRelayHelpers';
import type { JSONObject } from './helpers/types';
export interface BaseEmbeddableExplorerOptions {
    target: string | HTMLElement;
    initialState?: {
        document?: string;
        variables?: JSONObject;
        headers?: Record<string, string>;
        displayOptions: {
            docsPanelState?: 'open' | 'closed';
            showHeadersAndEnvVars?: boolean;
            theme?: 'dark' | 'light';
        };
    };
    persistExplorerState?: boolean;
    handleRequest?: HandleRequest;
    includeCookies?: boolean;
    autoInviteOptions?: {
        accountId: string;
        inviteToken: string;
    };
}
interface EmbeddableExplorerOptionsWithSchema extends BaseEmbeddableExplorerOptions {
    schema: string | IntrospectionQuery;
    endpointUrl: string;
    graphRef?: never;
}
interface EmbeddableExplorerOptionsWithGraphRef extends BaseEmbeddableExplorerOptions {
    graphRef: string;
    schema?: never;
    endpointUrl?: never;
}
export declare type EmbeddableExplorerOptions = EmbeddableExplorerOptionsWithSchema | EmbeddableExplorerOptionsWithGraphRef;
declare type InternalEmbeddableExplorerOptions = EmbeddableExplorerOptions & {
    __testLocal__?: boolean;
};
export declare class EmbeddedExplorer {
    options: InternalEmbeddableExplorerOptions;
    handleRequest: HandleRequest;
    embeddedExplorerURL: string;
    embeddedExplorerIFrameElement: HTMLIFrameElement;
    uniqueEmbedInstanceId: number;
    __testLocal__: boolean;
    private disposable;
    constructor(options: EmbeddableExplorerOptions);
    dispose(): void;
    injectEmbed(): HTMLIFrameElement;
    validateOptions(): void;
    getEmbeddedExplorerURL: () => string;
    updateSchemaInEmbed({ schema, }: {
        schema?: string | IntrospectionQuery | undefined;
    }): void;
}
export {};
