export declare const exampleSchema = "\"\"\"\nThe basic book in the graph\n\"\"\"\ntype Book implements Product {\n  \"\"\"\n  All books can be found by an isbn\n  \"\"\"\n  isbn: String!\n\n  \"\"\"\n  The title of the book\n  \"\"\"\n  title: String\n\n  \"\"\"\n  The year the book was published\n  \"\"\"\n  year: Int\n\n  \"\"\"\n  A simple list of similar books\n  \"\"\"\n  similarBooks: [Book]\n\n  \"\"\"\n  Since books are now products, we can also use their upc as a primary id\n  \"\"\"\n  upc: String!\n\n  \"\"\"\n  The name of a book is the book's title + year published\n  \"\"\"\n  name(delimeter: String = \" \"): String\n  price: Int\n  weight: Int\n  reviews: [Review]\n  reviewList(first: Int = 5, after: Int = 0): ReviewConnection\n\n  \"\"\"\n  relatedReviews for a book use the knowledge of similarBooks from the books\n  service to return related reviews that may be of interest to the user\n  \"\"\"\n  relatedReviews(first: Int = 5, after: Int = 0): ReviewConnection\n}\n\n\"\"\"\nInformation about the brand Ikea\n\"\"\"\ntype Ikea {\n  \"\"\"\n  Which asile to find an item\n  \"\"\"\n  asile: Int\n}\n\n\"\"\"\nInformation about the brand Amazon\n\"\"\"\ntype Amazon {\n  \"\"\"\n  The url of a referrer for a product\n  \"\"\"\n  referrer: String\n}\n\n\"\"\"\nA union of all brands represented within the store\n\"\"\"\nunion Brand = Ikea | Amazon\n\nenum ProductType {\n  LATEST\n  TRENDING\n}\n\ntype PageInfo {\n  hasNextPage: Boolean\n  hasPreviousPage: Boolean\n}\n\n\"\"\"\nA connection edge for the Product type\n\"\"\"\ntype ProductEdge {\n  product: Product\n}\n\n\"\"\"\nA connection wrapper for lists of products\n\"\"\"\ntype ProductConnection {\n  \"\"\"\n  Helpful metadata about the connection\n  \"\"\"\n  pageInfo: PageInfo\n\n  \"\"\"\n  List of products returned by the search\n  \"\"\"\n  edges: [ProductEdge]\n}\n\n\"\"\"\nThe Product type represents all products within the system\n\"\"\"\ninterface Product {\n  \"\"\"\n  The primary identifier of products in the graph\n  \"\"\"\n  upc: String!\n\n  \"\"\"\n  The display name of the product\n  \"\"\"\n  name: String\n\n  \"\"\"\n  A simple integer price of the product in US dollars\n  \"\"\"\n  price: Int\n\n  \"\"\"\n  How much the product weighs in kg\n  \"\"\"\n  weight: Int @deprecated(reason: \"Not all product's have a weight\")\n\n  \"\"\"\n  A simple list of all reviews for a product\n  \"\"\"\n  reviews: [Review]\n    @deprecated(\n      reason: \"The reviews field on product is deprecated to roll over the return type from a simple list to a paginated list. The easiest way to fix your operations is to alias the new field reviewList to review\"\n    )\n\n  \"\"\"\n  A paginated list of reviews. This field naming is temporary while all clients\n  migrate off of the un-paginated version of this field call reviews. To ease this migration,\n  alias your usage of reviewList to reviews so that after the roll over is finished, you\n  can remove the alias and use the final field name:\n\n    {\n      ... on Product {\n        reviews: reviewList {\n          edges {\n            review {\n              body\n            }\n          }\n        }\n      }\n    }\n  \"\"\"\n  reviewList(first: Int = 5, after: Int = 0): ReviewConnection\n}\n\n\"\"\"\nThe Furniture type represents all products which are items\nof furniture.\n\"\"\"\ntype Furniture implements Product {\n  \"\"\"\n  The modern primary identifier for furniture\n  \"\"\"\n  upc: String!\n\n  \"\"\"\n  The SKU field is how furniture was previously stored, and still exists in some legacy systems\n  \"\"\"\n  sku: String!\n  name: String\n  price: Int\n\n  \"\"\"\n  The brand of furniture\n  \"\"\"\n  brand: Brand\n  weight: Int\n  reviews: [Review]\n  reviewList(first: Int = 5, after: Int = 0): ReviewConnection\n}\n\n\"\"\"\nThe base User in Acephei\n\"\"\"\ntype User {\n  \"\"\"\n  A globally unique id for the user\n  \"\"\"\n  id: ID!\n\n  \"\"\"\n  The users full name as provided\n  \"\"\"\n  name: String\n\n  \"\"\"\n  The account username of the user\n  \"\"\"\n  username: String\n\n  \"\"\"\n  A list of all reviews by the user\n  \"\"\"\n  reviews: [Review]\n}\n\n\"\"\"\nA review is any feedback about products across the graph\n\"\"\"\ntype Review {\n  id: ID!\n\n  \"\"\"\n  The plain text version of the review\n  \"\"\"\n  body: String\n\n  \"\"\"\n  The user who authored the review\n  \"\"\"\n  author: User\n\n  \"\"\"\n  The product which this review is about\n  \"\"\"\n  product: Product\n}\n\n\"\"\"\nA connection edge for the Review type\n\"\"\"\ntype ReviewEdge {\n  review: Review\n}\n\n\"\"\"\nA connection wrapper for lists of reviews\n\"\"\"\ntype ReviewConnection {\n  \"\"\"\n  Helpful metadata about the connection\n  \"\"\"\n  pageInfo: PageInfo\n\n  \"\"\"\n  List of reviews returned by the search\n  \"\"\"\n  edges: [ReviewEdge]\n}\n\ntype Query {\n  \"\"\"\n  Fetch a simple list of products with an offset\n  \"\"\"\n  topProducts(first: Int = 5): [Product]\n    @deprecated(reason: \"Use products instead\")\n\n  \"\"\"\n  Fetch a paginated list of products based on a filter type.\n  \"\"\"\n  products(first: Int = 5, after: Int = 0, type: ProductType): ProductConnection\n\n  \"\"\"\n  The currently authenticated user root. All nodes off of this\n  root will be authenticated as the current user\n  \"\"\"\n  me: User\n}";
