import type { ExecutionResult, GraphQLError, IntrospectionQuery } from 'graphql';
import { PARTIAL_AUTHENTICATION_TOKEN_RESPONSE, EXPLORER_QUERY_MUTATION_RESPONSE, HANDSHAKE_RESPONSE, SCHEMA_ERROR, SCHEMA_RESPONSE, SET_PARTIAL_AUTHENTICATION_TOKEN_FOR_PARENT, EXPLORER_LISTENING_FOR_PARTIAL_TOKEN, PARENT_LOGOUT_SUCCESS, TRIGGER_LOGOUT_IN_PARENT, EXPLORER_SUBSCRIPTION_RESPONSE, EXPLORER_SET_SOCKET_ERROR, EXPLORER_SET_SOCKET_STATUS, TRACE_KEY, EXPLORER_LISTENING_FOR_HANDSHAKE, EXPLORER_QUERY_MUTATION_REQUEST, EXPLORER_SUBSCRIPTION_REQUEST, EXPLORER_SUBSCRIPTION_TERMINATION, EXPLORER_LISTENING_FOR_SCHEMA, INTROSPECTION_QUERY_WITH_HEADERS } from './constants';
import type { JSONValue } from './types';
import type { ObjMap } from 'graphql/jsutils/ObjMap';
import type { GraphQLSubscriptionLibrary } from './subscriptionPostMessageRelayHelpers';
export declare type HandleRequest = (endpointUrl: string, options: Omit<RequestInit, 'headers'> & {
    headers: Record<string, string>;
}) => Promise<Response>;
export declare function sendPostMessageToEmbed({ message, embeddedIFrameElement, embedUrl, }: {
    message: OutgoingEmbedMessage;
    embeddedIFrameElement: HTMLIFrameElement;
    embedUrl: string;
}): void;
export declare type ResponseError = {
    message: string;
    stack?: string;
};
export declare type SocketStatus = 'disconnected' | 'connecting' | 'connected';
interface ResponseData {
    data?: Record<string, unknown> | JSONValue | ObjMap<unknown>;
    path?: Array<string | number>;
    errors?: Array<GraphQLError>;
    extensions?: {
        [TRACE_KEY]?: string;
    };
}
declare type ExplorerResponse = ResponseData & {
    incremental?: Array<ResponseData & {
        path: NonNullable<ResponseData['path']>;
    }>;
    error?: {
        message: string;
        stack?: string;
    };
    status?: number;
    headers?: Record<string, string> | [Record<string, string>, ...Record<string, string>[]];
    hasNext?: boolean;
    size?: number;
};
export declare type OutgoingEmbedMessage = {
    name: typeof SCHEMA_ERROR;
    error?: string;
    errors?: Array<GraphQLError>;
} | {
    name: typeof SCHEMA_RESPONSE;
    schema: IntrospectionQuery | string | undefined;
} | {
    name: typeof HANDSHAKE_RESPONSE;
    graphRef?: string;
    inviteToken?: string;
    accountId?: string;
    parentHref?: string;
} | {
    name: typeof PARTIAL_AUTHENTICATION_TOKEN_RESPONSE;
    partialToken?: string;
} | {
    name: typeof EXPLORER_QUERY_MUTATION_RESPONSE;
    operationId: string;
    response: ExplorerResponse;
} | {
    name: typeof EXPLORER_SUBSCRIPTION_RESPONSE;
    operationId: string;
    response: {
        data?: ExecutionResult<JSONValue | ObjMap<unknown>>;
        error?: Error;
        errors?: [Error];
    };
} | {
    name: typeof EXPLORER_SET_SOCKET_ERROR;
    error: Error | undefined;
} | {
    name: typeof EXPLORER_SET_SOCKET_STATUS;
    status: SocketStatus;
} | {
    name: typeof PARENT_LOGOUT_SUCCESS;
};
export declare type IncomingEmbedMessage = MessageEvent<{
    name: typeof EXPLORER_LISTENING_FOR_HANDSHAKE;
}> | MessageEvent<{
    name: typeof EXPLORER_QUERY_MUTATION_REQUEST;
    operationName?: string;
    operation: string;
    operationId: string;
    variables?: Record<string, string>;
    headers?: Record<string, string>;
    endpointUrl?: string;
}> | MessageEvent<{
    name: typeof EXPLORER_SUBSCRIPTION_REQUEST;
    operationId: string;
    operation: string;
    variables?: Record<string, string>;
    operationName?: string;
    headers?: Record<string, string>;
    subscriptionUrl: string;
    protocol: GraphQLSubscriptionLibrary;
}> | MessageEvent<{
    name: typeof EXPLORER_SUBSCRIPTION_TERMINATION;
    operationId: string;
}> | MessageEvent<{
    name: typeof EXPLORER_LISTENING_FOR_SCHEMA;
}> | MessageEvent<{
    name: typeof SET_PARTIAL_AUTHENTICATION_TOKEN_FOR_PARENT;
    localStorageKey: string;
    partialToken: string;
}> | MessageEvent<{
    name: typeof TRIGGER_LOGOUT_IN_PARENT;
    localStorageKey: string;
}> | MessageEvent<{
    name: typeof EXPLORER_LISTENING_FOR_PARTIAL_TOKEN;
    localStorageKey?: string;
}> | MessageEvent<{
    name: typeof INTROSPECTION_QUERY_WITH_HEADERS;
    introspectionRequestBody: string;
    introspectionRequestHeaders: Record<string, string>;
    sandboxEndpointUrl?: string;
}>;
export declare function executeOperation({ endpointUrl, handleRequest, operation, operationName, variables, headers, embeddedIFrameElement, operationId, embedUrl, }: {
    endpointUrl: string;
    handleRequest: HandleRequest;
    operation: string;
    operationId: string;
    embeddedIFrameElement: HTMLIFrameElement;
    operationName: string | undefined;
    variables?: Record<string, string>;
    headers?: Record<string, string>;
    embedUrl: string;
}): Promise<void>;
export declare const handleAuthenticationPostMessage: ({ event, embeddedIFrameElement, embedUrl, }: {
    event: IncomingEmbedMessage;
    embeddedIFrameElement: HTMLIFrameElement;
    embedUrl: string;
}) => void;
export {};
