/// <reference types="zen-observable" />
import { Observable } from 'zen-observable-ts';
import type { GraphQLError } from 'graphql';
import type { JSONValue } from './types';
import type { TRACE_KEY } from './constants';
import type MIMEType from 'whatwg-mimetype';
interface ResponseData {
    data: Record<string, unknown> | JSONValue | undefined;
    path?: Array<string | number>;
    errors?: Array<GraphQLError>;
    extensions?: {
        [TRACE_KEY]?: string;
    };
}
export interface MultipartResponse {
    data: ResponseData & {
        incremental?: Array<ResponseData & {
            path: NonNullable<ResponseData['path']>;
        }>;
        error?: {
            message: string;
            stack?: string;
        };
        hasNext?: boolean;
    };
    headers?: Record<string, string>;
    size: number;
}
export declare function readMultipartWebStream(response: Response, mimeType: MIMEType): Observable<MultipartResponse>;
export {};
