import type { JSONObject } from './types';
export declare type GraphQLSubscriptionLibrary = 'subscriptions-transport-ws' | 'graphql-ws';
export declare function setParentSocketError({ error, embeddedIFrameElement, embedUrl, }: {
    error: Error | undefined;
    embeddedIFrameElement: HTMLIFrameElement;
    embedUrl: string;
}): void;
export declare function executeSubscription({ operation, operationName, variables, headers, embeddedIFrameElement, operationId, embedUrl, subscriptionUrl, protocol, }: {
    operation: string;
    operationId: string;
    embeddedIFrameElement: HTMLIFrameElement;
    operationName: string | undefined;
    variables?: JSONObject;
    headers?: Record<string, string>;
    embedUrl: string;
    subscriptionUrl: string;
    protocol: GraphQLSubscriptionLibrary;
}): void;
