/// <reference types="react" />
import type { IntrospectionQuery } from 'graphql';
import { BaseEmbeddableExplorerOptions } from '../EmbeddedExplorer';
interface EmbeddableExplorerOptionsWithSchema extends Omit<BaseEmbeddableExplorerOptions, 'target'> {
    schema: string | IntrospectionQuery;
    endpointUrl: string;
    graphRef?: never;
}
interface EmbeddableExplorerOptionsWithGraphRef extends Omit<BaseEmbeddableExplorerOptions, 'target'> {
    graphRef: string;
    endpointUrl?: never;
    schema?: never;
}
export declare type EmbeddableExplorerOptions = EmbeddableExplorerOptionsWithSchema | EmbeddableExplorerOptionsWithGraphRef;
export declare function ApolloExplorerReact(props: EmbeddableExplorerOptions & {
    className?: string;
}): JSX.Element;
export {};
