export interface DatepickerDialogClosed extends Pick<DatepickerDialog, 'value'> {
    opened: boolean;
}
export declare type DatepickerDialogOpened = DatepickerDialogClosed & DatepickerFirstUpdated;
import '@material/mwc-button/mwc-button.js';
import { LitElement } from 'lit';
import type { WeekNumberType } from 'nodemod/dist/calendar/typings.js';
import type { DatepickerFirstUpdated, StartView } from './custom_typings.js';
export declare class DatepickerDialog extends LitElement {
    static styles: import("lit").CSSResult[];
    firstDayOfWeek: number;
    showWeekNumber: boolean;
    weekNumberType: WeekNumberType;
    landscape: boolean;
    startView: StartView;
    min?: string;
    max?: string;
    value: string;
    locale: string;
    disabledDays: string;
    disabledDates: string;
    weekLabel: string;
    dragRatio: number;
    clearLabel: string;
    dismissLabel: string;
    confirmLabel: string;
    noFocusTrap: boolean;
    alwaysResetValue: boolean;
    private _contentContainer?;
    private _dialogConfirm?;
    private _hasNativeWebAnimation;
    private _focusable?;
    private _focusTrap?;
    private _opened;
    open(): Promise<void>;
    close(): Promise<void>;
    protected shouldUpdate(): boolean;
    protected firstUpdated(): void;
    protected getUpdateComplete(): Promise<boolean>;
    protected render(): import("lit-html").TemplateResult<1>;
    private _padStart;
    private _setToday;
    private _updateValue;
    private _update;
    private _updateWithKey;
    private _setFocusable;
    private get _datepicker();
    private get _scrim();
}
declare global {
    interface HTMLElementEventMap {
        'datepicker-dialog-closed': CustomEvent<DatepickerDialogClosed>;
        'datepicker-dialog-first-updated': CustomEvent<DatepickerFirstUpdated>;
        'datepicker-dialog-opened': CustomEvent<DatepickerDialogOpened>;
    }
}
//# sourceMappingURL=datepicker-dialog.d.ts.map