interface ParamUpdatedChanged extends Omit<Datepicker, keyof LitElement> {
    _selectedDate: Date;
    _focusedDate: Date;
    _startView: StartView;
}
import { LitElement, TemplateResult } from 'lit';
import type { WeekNumberType } from 'nodemod/dist/calendar/typings.js';
import type { DatepickerFirstUpdated, DatepickerValueUpdated, StartView } from './custom_typings.js';
export declare class Datepicker extends LitElement {
    static styles: import("lit").CSSResult[];
    firstDayOfWeek: number;
    showWeekNumber: boolean;
    weekNumberType: WeekNumberType;
    landscape: boolean;
    get startView(): StartView;
    set startView(val: StartView);
    get min(): string | undefined;
    set min(val: string | undefined);
    get max(): string | undefined;
    set max(val: string | undefined);
    get value(): string;
    set value(val: string);
    locale: string;
    disabledDays: string;
    disabledDates: string;
    weekLabel: string;
    inline: boolean;
    dragRatio: number;
    private _selectedDate;
    private _focusedDate;
    private _startView?;
    private _yearViewFullList?;
    private _buttonSelectorYear?;
    private _yearViewListItem?;
    private _min;
    private _max;
    private _hasMin;
    private _hasMax;
    private _todayDate;
    private _maxDate;
    private _yearList;
    private _formatters;
    private _disabledDaysSet;
    private _disabledDatesSet;
    private _lastSelectedDate?;
    private _tracker?;
    private _dx;
    private _hasNativeWebAnimation;
    private _updatingDateWithKey;
    constructor();
    disconnectedCallback(): void;
    protected render(): TemplateResult<1>;
    protected firstUpdated(): void;
    protected updated(changed: Map<keyof ParamUpdatedChanged, unknown>): Promise<void>;
    private _focusElement;
    private _renderHeaderSelectorButton;
    private _renderDatepickerYearList;
    private _renderDatepickerCalendar;
    private _updateView;
    private _updateMonth;
    private _updateYear;
    private _updateFocusedDate;
    private _updateFocusedDateWithKeyboard;
    private _isInVisibleMonth;
    get calendarsContainer(): HTMLDivElement | null;
}
declare global {
    interface HTMLButtonElement {
        year: number;
    }
    interface HTMLTableCellElement {
        day: string;
        fullDate: Date;
    }
    interface HTMLElementEventMap {
        'datepicker-first-updated': CustomEvent<DatepickerFirstUpdated>;
        'datepicker-animation-finished': CustomEvent<undefined>;
        'datepicker-value-updated': CustomEvent<DatepickerValueUpdated>;
    }
}
export {};
//# sourceMappingURL=datepicker.d.ts.map