import * as React from "react";
import { Component } from "./Component";
import { Core } from "./Core";
import { CoreRootContextValue } from "./CoreRoot";
interface DOMSearch {
    visited: HTMLElement[];
    accepted: HTMLElement[];
    visitedIds: string[];
    acceptedIds: string[];
}
interface Props {
    component: Component;
    coreContext: CoreRootContextValue;
    core: Core;
}
declare enum Ready {
    NOPE = 0,
    ALMOST = 1,
    YEP = 2
}
interface State {
    portals: Component[];
    ready: Ready;
}
export declare class ComponentEnvelope extends React.Component<Props, State> {
    static AfOpenComponentAttr: string;
    static AfComponentAttr: string;
    private ref;
    private containers;
    private mutationObserver?;
    constructor(props: Props);
    private updateReactRef;
    private updateNonReactRef;
    private updateRef;
    private updateComponentContainerRef;
    private updateMutationObserver;
    private onMutation;
    private isSubComponentContainer;
    private disconnectedMutationObserver;
    private refreshPortals;
    private makePortal;
    findContainers(af_componentIds: string[]): DOMSearch;
    componentDidMount(): void;
    componentDidUpdate(prevProps: Readonly<Props>, prevState: Readonly<State>, snapshot?: any): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
}
export declare function findChildContainers(container: HTMLElement): HTMLElement[];
export {};
