import * as React from "react";
import { Core } from "./Core";
import { Component } from "./Component";
interface Props {
    exposing: (ref: () => CoreRoot) => void;
    app: Component;
    core: Core;
}
interface State {
    components: Component[];
}
export interface ComponentMap {
    [af_componentId: string]: Component;
}
export interface CoreRootContextValue {
    components: ComponentMap;
}
export declare const CoreRootContext: React.Context<CoreRootContextValue>;
export declare const CoreContext: React.Context<Core | undefined>;
export declare class CoreRoot extends React.Component<Props, State> {
    constructor(props: Props);
    register(...components: Component[]): void;
    deregister(...ids: string[]): void;
    private buildContext;
    render(): JSX.Element;
}
export {};
