/**
 * Column selection function.
 * @typedef {(table: import('../table/Table.js').Table) => string[]} ColumnSelectFunction
 */
/**
 * Column selection options.
 * @typedef {string[]|ColumnSelectFunction} ColumnSelectOptions
 */
/**
 * Column format options. The object keys should be column names.
 * The object values should be formatting functions or objects.
 * If specified, these override any automatically inferred options.
 * @typedef {Object.<string, import('./value.js').ValueFormatOptions>} ColumnFormatOptions
 */
/**
 * Column alignment options. The object keys should be column names.
 * The object values should be aligment strings, one of 'l' (left),
 * 'c' (center), or 'r' (right).
 * If specified, these override any automatically inferred options.
 * @typedef {Object.<string, 'l'|'c'|'r'>} ColumnAlignOptions
 */
/**
 * Return a potentially filtered list of column names.
 * @param {import('../table/Table.js').Table} table A data table.
 * @param {ColumnSelectOptions} names The column names to select.
 * @returns {string[]} The selected column names.
 */
export function columns(table: import("../table/Table.js").Table, names: ColumnSelectOptions): string[];
export function formats(table: any, names: any, options: any): {
    align: {};
    format: {};
};
export function scan(table: any, names: any, limit: number, offset: any, ctx: any): void;
/**
 * Column selection function.
 */
export type ColumnSelectFunction = (table: import("../table/Table.js").Table) => string[];
/**
 * Column selection options.
 */
export type ColumnSelectOptions = string[] | ColumnSelectFunction;
/**
 * Column format options. The object keys should be column names.
 * The object values should be formatting functions or objects.
 * If specified, these override any automatically inferred options.
 */
export type ColumnFormatOptions = {
    [x: string]: import("./value.js").ValueFormatOptions;
};
/**
 * Column alignment options. The object keys should be column names.
 * The object values should be aligment strings, one of 'l' (left),
 * 'c' (center), or 'r' (right).
 * If specified, these override any automatically inferred options.
 */
export type ColumnAlignOptions = {
    [x: string]: "l" | "c" | "r";
};
