declare namespace _default {
    export function format_date(date: Date | number, shorten?: boolean): string;
    export function format_utcdate(date: Date | number, shorten?: boolean): string;
    export let now: () => number;
    export function timestamp(date: Date | number): number;
    export { datetime };
    export function year(date: Date | number): number;
    export function quarter(date: Date | number): number;
    export function month(date: Date | number): number;
    export { week };
    export function date(date: Date | number): number;
    export { dayofyear };
    export function dayofweek(date: Date | number): number;
    export function hours(date: Date | number): number;
    export function minutes(date: Date | number): number;
    export function seconds(date: Date | number): number;
    export function milliseconds(date: Date | number): number;
    export { utcdatetime };
    export function utcyear(date: Date | number): number;
    export function utcquarter(date: Date | number): number;
    export function utcmonth(date: Date | number): number;
    export { utcweek };
    export function utcdate(date: Date | number): number;
    export { utcdayofyear };
    export function utcdayofweek(date: Date | number): number;
    export function utchours(date: Date | number): number;
    export function utcminutes(date: Date | number): number;
    export function utcseconds(date: Date | number): number;
    export function utcmilliseconds(date: Date | number): number;
}
export default _default;
/**
 * Function to create a new Date value.
 * If no arguments are provided, the current time is used.
 * @param {number} [year] The year.
 * @param {number} [month=0] The (zero-based) month.
 * @param {number} [date=1] The date within the month.
 * @param {number} [hours=0] The hour within the day.
 * @param {number} [minutes=0] The minute within the hour.
 * @param {number} [seconds=0] The second within the minute.
 * @param {number} [milliseconds=0] The milliseconds within the second.
 * @return {Date} The resuting Date value.
 */
declare function datetime(year?: number, month?: number, date?: number, hours?: number, minutes?: number, seconds?: number, milliseconds?: number, ...args: any[]): Date;
/**
 * Return the current week of the year in local time as a number
 * between 1 and 52.
 * @param {Date|number} date A date or timestamp.
 * @return {number} The week of the year in local time.
 */
declare function week(date: Date | number, firstday: any): number;
/**
 * Return the current day of the year in local time as a number
 * between 1 and 366.
 * @param {Date|number} date A date or timestamp.
 * @return {number} The day of the year in local time.
 */
declare function dayofyear(date: Date | number): number;
/**
 * Function to create a new Date value according to UTC time.
 * If no arguments are provided, the current time is used.
 * @param {number} [year] The year.
 * @param {number} [month=0] The (zero-based) month.
 * @param {number} [date=1] The date within the month.
 * @param {number} [hours=0] The hour within the day.
 * @param {number} [minutes=0] The minute within the hour.
 * @param {number} [seconds=0] The second within the minute.
 * @param {number} [milliseconds=0] The milliseconds within the second.
 * @return {Date} The resuting Date value.
 */
declare function utcdatetime(year?: number, month?: number, date?: number, hours?: number, minutes?: number, seconds?: number, milliseconds?: number, ...args: any[]): Date;
/**
 * Return the current week of the year in UTC time as a number
 * between 1 and 52.
 * @param {Date|number} date A date or timestamp.
 * @return {number} The week of the year in UTC time.
 */
declare function utcweek(date: Date | number, firstday: any): number;
/**
 * Return the current day of the year in UTC time as a number
 * between 1 and 366.
 * @param {Date|number} date A date or timestamp.
 * @return {number} The day of the year in UTC time.
 */
declare function utcdayofyear(date: Date | number): number;
