declare const _default: {
    parse_date: (value: any) => Date;
    parse_float: (value: any) => number;
    parse_int: (value: any, radix?: number) => number;
    endswith: (value: any, search: string, length?: number) => boolean;
    match: (value: any, regexp: any, index: number | string) => string | string[];
    normalize: (value: any, form: string) => string;
    padend: (value: any, length: number, fill?: string) => string;
    padstart: (value: any, length: number, fill?: string) => string;
    upper: (value: any) => string;
    lower: (value: any) => string;
    repeat: (value: any, number: any) => string;
    replace: (value: any, pattern: any, replacement: any) => string;
    split: (value: any, separator: any, limit?: number) => string[];
    startswith: (value: any, search: string, position?: number) => boolean;
    substring: (value: any, start?: number, end?: number) => string;
    trim: (value: any) => string;
    has: <K, V>(object: Map<K, V> | Set<K> | Record<K, V>, key: K) => boolean;
    keys: <K, V>(object: Map<K, V> | Record<K, V>) => K[];
    values: <K, V>(object: Map<K, V> | Set<V> | Record<K, V>) => V[];
    entries: <K, V>(object: Map<K, V> | Set<V> | Record<K, V>) => [K, V][];
    object: <K, V>(entries: Iterable<[K, V]>) => Record<K, V>;
    random: typeof import("../../util/random.js").random;
    is_nan: (number: unknown) => boolean;
    is_finite: (number: unknown) => boolean;
    abs: (x: number) => number;
    cbrt: (x: number) => number;
    ceil: (x: number) => number;
    clz32: (x: number) => number;
    exp: (x: number) => number;
    expm1: (x: number) => number;
    floor: (x: number) => number;
    fround: (x: number) => number;
    greatest: (...values: number[]) => number;
    least: (...values: number[]) => number;
    log: (x: number) => number;
    log10: (x: number) => number;
    log1p: (x: number) => number;
    log2: (x: number) => number;
    pow: (x: number, y: number) => number;
    round: (x: number) => number;
    sign: (x: number) => number;
    sqrt: (x: number) => number;
    trunc: (x: number) => number;
    degrees: (radians: number) => number;
    radians: (degrees: number) => number;
    acos: (x: number) => number;
    acosh: (x: number) => number;
    asin: (x: number) => number;
    asinh: (x: number) => number;
    atan: (x: number) => number;
    atan2: (y: number, x: number) => number;
    atanh: (x: number) => number;
    cos: (x: number) => number;
    cosh: (x: number) => number;
    sin: (x: number) => number;
    sinh: (x: number) => number;
    tan: (x: number) => number;
    tanh: (x: number) => number;
    parse_json: (value: string) => any;
    to_json: (value: any) => string;
    format_date: (date: Date | number, shorten?: boolean) => string;
    format_utcdate: (date: Date | number, shorten?: boolean) => string;
    now: () => number;
    timestamp: (date: Date | number) => number;
    datetime: (year?: number, month?: number, date?: number, hours?: number, minutes?: number, seconds?: number, milliseconds?: number, ...args: any[]) => Date;
    year: (date: Date | number) => number;
    quarter: (date: Date | number) => number;
    month: (date: Date | number) => number;
    week: (date: Date | number, firstday: any) => number;
    date: (date: Date | number) => number;
    dayofyear: (date: Date | number) => number;
    dayofweek: (date: Date | number) => number;
    hours: (date: Date | number) => number;
    minutes: (date: Date | number) => number;
    seconds: (date: Date | number) => number;
    milliseconds: (date: Date | number) => number;
    utcdatetime: (year?: number, month?: number, date?: number, hours?: number, minutes?: number, seconds?: number, milliseconds?: number, ...args: any[]) => Date;
    utcyear: (date: Date | number) => number;
    utcquarter: (date: Date | number) => number;
    utcmonth: (date: Date | number) => number;
    utcweek: (date: Date | number, firstday: any) => number;
    utcdate: (date: Date | number) => number;
    utcdayofyear: (date: Date | number) => number;
    utcdayofweek: (date: Date | number) => number;
    utchours: (date: Date | number) => number;
    utcminutes: (date: Date | number) => number;
    utcseconds: (date: Date | number) => number;
    utcmilliseconds: (date: Date | number) => number;
    compact: <T>(array: T[]) => T[];
    concat: <T>(...values: (T | T[])[]) => T[];
    includes: <T>(sequence: T[], value: T, index?: number) => boolean;
    indexof: <T>(sequence: T[] | string, value: T) => number;
    join: <T>(array: T[], delim: string) => string;
    lastindexof: <T>(sequence: T[] | string, value: T) => number;
    length: (sequence: any[] | string) => number;
    pluck: (array: any[], property: string) => any[];
    reverse: <T>(sequence: T[] | string) => T[] | string;
    slice: <T>(sequence: T[] | string, start?: number, end?: number) => T[] | string;
    bin: typeof bin;
    equal: typeof equal;
    recode: typeof recode;
    sequence: typeof sequence;
};
export default _default;
import bin from './bin.js';
import equal from './equal.js';
import recode from './recode.js';
import sequence from './sequence.js';
