/**
 * Check if an aggregate function with the given name exists.
 * @param {string} name The name of the aggregate function.
 * @return {boolean} True if found, false otherwise.
 */
export function hasAggregate(name: string): boolean;
/**
 * Check if a window function with the given name exists.
 * @param {string} name The name of the window function.
 * @return {boolean} True if found, false otherwise.
 */
export function hasWindow(name: string): boolean;
/**
 * Check if an expression function with the given name exists.
 * @param {string} name The name of the function.
 * @return {boolean} True if found, false otherwise.
 */
export function hasFunction(name: string): boolean;
/**
 * Get an aggregate function definition.
 * @param {string} name The name of the aggregate function.
 * @return {import('./aggregate-functions.js').AggregateDef}
 *  The aggregate function definition, or undefined if not found.
 */
export function getAggregate(name: string): import("./aggregate-functions.js").AggregateDef;
/**
 * Get a window function definition.
 * @param {string} name The name of the window function.
 * @return {import('./window-functions.js').WindowDef}
 *  The window function definition, or undefined if not found.
 */
export function getWindow(name: string): import("./window-functions.js").WindowDef;
/**
 * Get an expression function definition.
 * @param {string} name The name of the function.
 * @return {Function} The function instance, or undefined if not found.
 */
export function getFunction(name: string): Function;
export { default as aggregateFunctions } from "./aggregate-functions.js";
export { default as windowFunctions } from "./window-functions.js";
export { default as functions } from "./functions/index.js";
