/**
 * @param {string} name
 * @param {any | any[]} [fields]
 * @param {any | any[]} [params]
 */
export function op(name: string, fields?: any | any[], params?: any | any[]): Op;
export class Op {
    constructor(name: any, fields: any, params: any);
    name: any;
    fields: any;
    params: any;
    toString(): string;
    toObject(): {
        expr: string;
        func: boolean;
    };
}
export function any(field: any): Op;
export function count(): Op;
export function array_agg(field: any): Op;
export function array_agg_distinct(field: any): Op;
export function map_agg(key: any, value: any): Op;
export function object_agg(key: any, value: any): Op;
export function entries_agg(key: any, value: any): Op;
declare const _default: {
    /**
     * Generate an object representing the current table row.
     * @param {...string} names The column names to include in the object.
     *  If unspecified, all columns are included.
     * @return {Struct} The generated row object.
     */
    row_object: (...names: string[]) => Struct;
    /**
     * Aggregate function to count the number of records (rows).
     * @returns {number} The count of records.
     */
    count: () => Op;
    /**
     * Aggregate function returning an arbitrary observed value.
     * @template T
     * @param {T} field The data field.
     * @return {T} An arbitrary observed value.
     */
    any: (field: any) => Op;
    /**
     * Aggregate function to collect an array of values.
     * @template T
     * @param {T} field The data field.
     * @return {Array<T>} A list of values.
     */
    array_agg: (field: any) => Op;
    /**
     * Aggregate function to collect an array of distinct (unique) values.
     * @template T
     * @param {T} field The data field.
     * @return {Array<T>} An array of unique values.
     */
    array_agg_distinct: (field: any) => Op;
    /**
     * Aggregate function to create an object given input key and value fields.
     * @template K, V
     * @param {K} key The object key field.
     * @param {V} value The object value field.
     * @return {Record<K, V>} An object of key-value pairs.
     */
    object_agg: (key: any, value: any) => Op;
    /**
     * Aggregate function to create a Map given input key and value fields.
     * @template K, V
     * @param {K} key The object key field.
     * @param {V} value The object value field.
     * @return {Map<K, V>} A Map of key-value pairs.
     */
    map_agg: (key: any, value: any) => Op;
    /**
     * Aggregate function to create an array in the style of Object.entries()
     * given input key and value fields.
     * @template K, V
     * @param {K} key The object key field.
     * @param {V} value The object value field.
     * @return {[K, V][]} An array of [key, value] arrays.
     */
    entries_agg: (key: any, value: any) => Op;
    /**
     * Aggregate function to count the number of valid values.
     * Invalid values are null, undefined, or NaN.
     * @param {*} field The data field.
     * @return {number} The count of valid values.
     */
    valid: (field: any) => number;
    /**
     * Aggregate function to count the number of invalid values.
     * Invalid values are null, undefined, or NaN.
     * @param {*} field The data field.
     * @return {number} The count of invalid values.
     */
    invalid: (field: any) => number;
    /**
     * Aggregate function to count the number of distinct values.
     * @param {*} field The data field.
     * @return {number} The count of distinct values.
     */
    distinct: (field: any) => number;
    /**
     * Aggregate function to determine the mode (most frequent) value.
     * @template T
     * @param {T} field The data field.
     * @return {T} The mode value.
     */
    mode: <T>(field: T) => T;
    /**
     * Aggregate function to sum values.
     * @param {*} field The data field.
     * @return {number} The sum of the values.
     */
    sum: (field: any) => number;
    /**
     * Aggregate function to multiply values.
     * @param {*} field The data field.
     * @return {number} The product of the values.
     */
    product: (field: any) => number;
    /**
     * Aggregate function for the mean (average) value.
     * @param {*} field The data field.
     * @return {number} The mean (average) of the values.
     */
    mean: (field: any) => number;
    /**
     * Aggregate function for the average (mean) value.
     * @param {*} field The data field.
     * @return {number} The average (mean) of the values.
     */
    average: (field: any) => number;
    /**
     * Aggregate function for the sample variance.
     * @param {*} field The data field.
     * @return {number} The sample variance of the values.
     */
    variance: (field: any) => number;
    /**
     * Aggregate function for the population variance.
     * @param {*} field The data field.
     * @return {number} The population variance of the values.
     */
    variancep: (field: any) => number;
    /**
     * Aggregate function for the sample standard deviation.
     * @param {*} field The data field.
     * @return {number} The sample standard deviation of the values.
     */
    stdev: (field: any) => number;
    /**
     * Aggregate function for the population standard deviation.
     * @param {*} field The data field.
     * @return {number} The population standard deviation of the values.
     */
    stdevp: (field: any) => number;
    /**
     * Aggregate function for the minimum value.
     * @template T
     * @param {T} field The data field.
     * @return {T} The minimum value.
     */
    min: <T>(field: T) => T;
    /**
     * Aggregate function for the maximum value.
     * @template T
     * @param {T} field The data field.
     * @return {T} The maximum value.
     */
    max: <T>(field: T) => T;
    /**
     * Aggregate function to compute the quantile boundary
     * of a data field for a probability threshold.
     * @param {*} field The data field.
     * @param {number} p The probability threshold.
     * @return {number} The quantile value.
     */
    quantile: (field: any, p: number) => number;
    /**
     * Aggregate function for the median value.
     * This is a shorthand for the 0.5 quantile value.
     * @param {*} field The data field.
     * @return {number} The median value.
     */
    median: (field: any) => number;
    /**
     * Aggregate function for the sample covariance between two variables.
     * @param {*} field1 The first data field.
     * @param {*} field2 The second data field.
     * @return {number} The sample covariance of the values.
     */
    covariance: (field1: any, field2: any) => number;
    /**
     * Aggregate function for the population covariance between two variables.
     * @param {*} field1 The first data field.
     * @param {*} field2 The second data field.
     * @return {number} The population covariance of the values.
     */
    covariancep: (field1: any, field2: any) => number;
    /**
     * Aggregate function for the product-moment correlation between two variables.
     * To instead compute a rank correlation, compute the average ranks for each
     * variable and then apply this function to the result.
     * @param {*} field1 The first data field.
     * @param {*} field2 The second data field.
     * @return {number} The correlation between the field values.
     */
    corr: (field1: any, field2: any) => number;
    /**
     * Aggregate function for calculating a binning scheme in terms of
     * the minimum bin boundary, maximum bin boundary, and step size.
     * @param {*} field The data field.
     * @param {number} [maxbins=15] The maximum number of allowed bins.
     * @param {boolean} [nice=true] Flag indicating if the bin min and max
     *  should snap to "nice" human-friendly values.
     * @param {number} [minstep] The minimum allowed step size between bins.
     * @param {number} [step] The exact step size to use between bins.
     *  If specified, the maxbins and minstep arguments are ignored.
     * @return {[number, number, number]} The bin [min, max, and step] values.
     */
    bins: (field: any, maxbins?: number, nice?: boolean, minstep?: number, step?: number) => [number, number, number];
    /**
     * Window function to assign consecutive row numbers, starting from 1.
     * @return {number} The row number value.
     */
    row_number: () => number;
    /**
     * Window function to assign a rank to each value in a group, starting
     * from 1. Peer values are assigned the same rank. Subsequent ranks
     * reflect the number of prior values: if the first two values tie for
     * rank 1, the third value is assigned rank 3.
     * @return {number} The rank value.
     */
    rank: () => number;
    /**
     * Window function to assign a fractional (average) rank to each value in
     * a group, starting from 1. Peer values are assigned the average of their
     * indices: if the first two values tie, both will be assigned rank 1.5.
     * @return {number} The peer-averaged rank value.
     */
    avg_rank: () => number;
    /**
     * Window function to assign a dense rank to each value in a group,
     * starting from 1. Peer values are assigned the same rank. Subsequent
     * ranks do not reflect the number of prior values: if the first two
     * values tie for rank 1, the third value is assigned rank 2.
     * @return {number} The dense rank value.
     */
    dense_rank: () => number;
    /**
     * Window function to assign a percentage rank to each value in a group.
     * The percent is calculated as (rank - 1) / (group_size - 1).
     * @return {number} The percentage rank value.
     */
    percent_rank: () => number;
    /**
     * Window function to assign a cumulative distribution value between 0 and 1
     * to each value in a group.
     * @return {number} The cumulative distribution value.
     */
    cume_dist: () => number;
    /**
     * Window function to assign a quantile (e.g., percentile) value to each
     * value in a group. Accepts an integer parameter indicating the number of
     * buckets to use (e.g., 100 for percentiles, 5 for quintiles).
     * @param {number} num The number of buckets for ntile calculation.
     * @return {number} The quantile value.
     */
    ntile: (num: number) => number;
    /**
     * Window function to assign a value that precedes the current value by
     * a specified number of positions. If no such value exists, returns a
     * default value instead.
     * @template T
     * @param {T} field The data field.
     * @param {number} [offset=1] The lag offset from the current value.
     * @param {T} [defaultValue=undefined] The default value.
     * @return {T} The lagging value.
     */
    lag: <T>(field: T, offset?: number, defaultValue?: T) => T;
    /**
     * Window function to assign a value that follows the current value by
     * a specified number of positions. If no such value exists, returns a
     * default value instead.
     * @template T
     * @param {T} field The data field.
     * @param {number} [offset=1] The lead offset from the current value.
     * @param {T} [defaultValue=undefined] The default value.
     * @return {T} The leading value.
     */
    lead: <T>(field: T, offset?: number, defaultValue?: T) => T;
    /**
     * Window function to assign the first value in a sliding window frame.
     * @template T
     * @param {T} field The data field.
     * @return {T} The first value in the current frame.
     */
    first_value: <T>(field: T) => T;
    /**
     * Window function to assign the last value in a sliding window frame.
     * @template T
     * @param {T} field The data field.
     * @return {T} The last value in the current frame.
     */
    last_value: <T>(field: T) => T;
    /**
     * Window function to assign the nth value in a sliding window frame
     * (counting from 1), or undefined if no such value exists.
     * @template T
     * @param {T} field The data field.
     * @param {number} nth The nth position, starting from 1.
     * @return {T} The nth value in the current frame.
     */
    nth_value: <T>(field: T, nth: number) => T;
    /**
     * Window function to fill in missing values with preceding values.
     * @template T
     * @param {T} field The data field.
     * @param {T} [defaultValue=undefined] The default value.
     * @return {T} The current value if valid, otherwise the first preceding
     *  valid value. If no such value exists, returns the default value.
     */
    fill_down: <T>(field: T, defaultValue?: T) => T;
    /**
     * Window function to fill in missing values with subsequent values.
     * @template T
     * @param {T} field The data field.
     * @param {T} [defaultValue=undefined] The default value.
     * @return {T} The current value if valid, otherwise the first subsequent
     *  valid value. If no such value exists, returns the default value.
     */
    fill_up: <T>(field: T, defaultValue?: T) => T;
    parse_date: (value: any) => Date;
    parse_float: (value: any) => number;
    parse_int: (value: any, radix?: number) => number;
    endswith: (value: any, search: string, length?: number) => boolean;
    match: (value: any, regexp: any, index: number | string) => string | string[];
    normalize: (value: any, form: string) => string;
    padend: (value: any, length: number, fill?: string) => string;
    padstart: (value: any, length: number, fill?: string) => string;
    upper: (value: any) => string;
    lower: (value: any) => string;
    repeat: (value: any, number: any) => string;
    replace: (value: any, pattern: any, replacement: any) => string;
    split: (value: any, separator: any, limit?: number) => string[];
    startswith: (value: any, search: string, position?: number) => boolean;
    substring: (value: any, start?: number, end?: number) => string;
    trim: (value: any) => string;
    has: <K, V>(object: Map<K, V> | Set<K> | Record<K, V>, key: K) => boolean;
    keys: <K, V>(object: Map<K, V> | Record<K, V>) => K[];
    values: <K, V>(object: Map<K, V> | Set<V> | Record<K, V>) => V[];
    entries: <K, V>(object: Map<K, V> | Set<V> | Record<K, V>) => [K, V][];
    object: <K, V>(entries: Iterable<[K, V]>) => Record<K, V>;
    random: typeof import("../util/random.js").random;
    is_nan: (number: unknown) => boolean;
    is_finite: (number: unknown) => boolean;
    abs: (x: number) => number;
    cbrt: (x: number) => number;
    ceil: (x: number) => number;
    clz32: (x: number) => number;
    exp: (x: number) => number;
    expm1: (x: number) => number;
    floor: (x: number) => number;
    fround: (x: number) => number;
    greatest: (...values: number[]) => number;
    least: (...values: number[]) => number;
    log: (x: number) => number;
    log10: (x: number) => number;
    log1p: (x: number) => number;
    log2: (x: number) => number;
    pow: (x: number, y: number) => number;
    round: (x: number) => number;
    sign: (x: number) => number;
    sqrt: (x: number) => number;
    trunc: (x: number) => number;
    degrees: (radians: number) => number;
    radians: (degrees: number) => number;
    acos: (x: number) => number;
    acosh: (x: number) => number;
    asin: (x: number) => number;
    asinh: (x: number) => number;
    atan: (x: number) => number;
    atan2: (y: number, x: number) => number;
    atanh: (x: number) => number;
    cos: (x: number) => number;
    cosh: (x: number) => number;
    sin: (x: number) => number;
    sinh: (x: number) => number;
    tan: (x: number) => number;
    tanh: (x: number) => number;
    parse_json: (value: string) => any;
    to_json: (value: any) => string;
    format_date: (date: Date | number, shorten?: boolean) => string;
    format_utcdate: (date: Date | number, shorten?: boolean) => string;
    now: () => number;
    timestamp: (date: Date | number) => number;
    datetime: (year?: number, month?: number, date?: number, hours?: number, minutes?: number, seconds?: number, milliseconds?: number, ...args: any[]) => Date;
    year: (date: Date | number) => number;
    quarter: (date: Date | number) => number;
    month: (date: Date | number) => number;
    week: (date: Date | number, firstday: any) => number;
    date: (date: Date | number) => number;
    dayofyear: (date: Date | number) => number;
    dayofweek: (date: Date | number) => number;
    hours: (date: Date | number) => number;
    minutes: (date: Date | number) => number;
    seconds: (date: Date | number) => number;
    milliseconds: (date: Date | number) => number;
    utcdatetime: (year?: number, month?: number, date?: number, hours?: number, minutes?: number, seconds?: number, milliseconds?: number, ...args: any[]) => Date;
    utcyear: (date: Date | number) => number;
    utcquarter: (date: Date | number) => number;
    utcmonth: (date: Date | number) => number;
    utcweek: (date: Date | number, firstday: any) => number;
    utcdate: (date: Date | number) => number;
    utcdayofyear: (date: Date | number) => number;
    utcdayofweek: (date: Date | number) => number;
    utchours: (date: Date | number) => number;
    utcminutes: (date: Date | number) => number;
    utcseconds: (date: Date | number) => number;
    utcmilliseconds: (date: Date | number) => number;
    compact: <T>(array: T[]) => T[];
    concat: <T>(...values: (T | T[])[]) => T[];
    includes: <T>(sequence: T[], value: T, index?: number) => boolean;
    indexof: <T>(sequence: T[] | string, value: T) => number;
    join: <T>(array: T[], delim: string) => string;
    lastindexof: <T>(sequence: T[] | string, value: T) => number;
    length: (sequence: any[] | string) => number;
    pluck: (array: any[], property: string) => any[];
    reverse: <T>(sequence: T[] | string) => T[] | string;
    slice: <T>(sequence: T[] | string, start?: number, end?: number) => T[] | string;
    bin: typeof import("./functions/bin.js").default;
    equal: typeof import("./functions/equal.js").default;
    recode: typeof import("./functions/recode.js").default;
    sequence: typeof import("./functions/sequence.js").default;
};
export default _default;
export type Struct = import("../table/types.js").Struct;
