/**
 * Register a custom aggregate function.
 * @param {string} name The name to use for the aggregate function.
 * @param {AggregateDef} def The aggregate operator definition.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified.
 */
export function addAggregateFunction(name: string, def: AggregateDef, options?: RegisterOptions): void;
/**
 * Register a custom window function.
 * @param {string} name The name to use for the window function.
 * @param {WindowDef} def The window operator definition.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified.
 */
export function addWindowFunction(name: string, def: WindowDef, options?: RegisterOptions): void;
/**
 * Register a function for use within table expressions.
 * If only a single argument is provided, it will be assumed to be a
 * function and the system will try to extract its name.
 * @param {string} name The name to use for the function.
 * @param {Function} fn A standard JavaScript function.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified, or if no name is provided
 *  and the input function is anonymous.
 */
export function addFunction(name: string, fn: Function, options?: RegisterOptions, ...args: any[]): void;
/**
 * Aggregate function definition.
 */
export type AggregateDef = import("./aggregate-functions.js").AggregateDef;
/**
 * Window function definition.
 */
export type WindowDef = import("./window-functions.js").WindowDef;
/**
 * Options for registering new functions.
 */
export type RegisterOptions = {
    /**
     * Flag indicating if the added
     * function can override an existing function with the same name.
     */
    override?: boolean;
};
