/**
 * Regroup table rows in response to a BitSet filter.
 * @param {import('./types.js').GroupBySpec} groups The current groupby specification.
 * @param {import('./BitSet.js').BitSet} filter The filter to apply.
 */
export function regroup(groups: import("./types.js").GroupBySpec, filter: import("./BitSet.js").BitSet): import("./types.js").GroupBySpec | {
    keys: Uint32Array;
    rows: any[];
    size: number;
    names: string[];
    get: import("./types.js").RowExpression[];
};
/**
 * Regroup table rows in response to a re-indexing.
 * This operation may or may not involve filtering of rows.
 * @param {import('./types.js').GroupBySpec} groups
 *  The current groupby specification.
 * @param {Function} scan Function to scan new row indices.
 * @param {boolean} filter Flag indicating if filtering may occur.
 * @param {number} nrows The number of rows in the new table.
 */
export function reindex(groups: import("./types.js").GroupBySpec, scan: Function, filter: boolean, nrows: number): {
    keys: Uint32Array;
    rows: Uint32Array | number[];
    size: number;
    names: string[];
    get: import("./types.js").RowExpression[];
};
export function nest(table: any, idx: any, obj: any, type: any): any;
