# array-every [![NPM version](https://badge.fury.io/js/array-every.svg)](http://badge.fury.io/js/array-every)

> Returns true if the callback returns truthy for all elements in the given array.

Based on [mout's](http://moutjs.com/) implementation of `every`.

## Install

**Install with NPM**

Install with [npm](https://www.npmjs.com/)

```bash
npm i array-every --save
```

**Install with Bower**

Install with [bower](http://bower.io/)

```bash
bower install array-every --save
```

## Usage

```js
var every = require('array-every');

every(['a', 'b', 'c'], function (ele) {
  return ele === 'a';
});
//=> false

every(['a', 'a', 'a'], function (ele) {
  return ele === 'a';
});
//=> true
```

## Related projects

* [array-every](https://github.com/jonschlinkert/array-every): Returns true if the callback returns truthy for all elements in the given array.
* [array-slice](https://github.com/jonschlinkert/array-slice): Array-slice method. Slices `array` from the `start` index up to, but not including, the `end`… [more](https://github.com/jonschlinkert/array-slice)
* [array-unique](https://github.com/jonschlinkert/array-unique): Return an array free of duplicate values. Fastest ES5 implementation.
* [filter-array](https://github.com/jonschlinkert/filter-array): Iterates over the elements in an array, returning an array with only the elements for… [more](https://github.com/jonschlinkert/filter-array)
* [index-of](https://github.com/jonschlinkert/index-of): Get the index of the first element in an array that returns truthy for the… [more](https://github.com/jonschlinkert/index-of)
* [make-iterator](https://github.com/jonschlinkert/make-iterator): Convert an argument into a valid iterator. Based on the `.makeIterator()` implementation in mout https://github.com/mout/mout.

## Running tests

Install dev dependencies:

```bash
npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/array-every/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright (c) 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on May 07, 2015._