/*!
 * array-every <https://github.com/jonschlinkert/array-every>
 *
 * Copyright (c) 2014 Jon Schlinkert, contributors.
 * Licensed under the MIT license.
 */

'use strict';

var iterator = require('make-iterator');

module.exports = function every(arr, cb, thisArg) {
  cb = iterator(cb, thisArg);
  var res = true;

  if (arr == null) return res;
  var len = arr.length;
  var i = 0;

  while (len--) {
    if (!cb(arr[i++], i, arr)) {
      res = false;
      break;
    }
  }

  return res;
};
