/*!
 * array-intersection <https://github.com/jonschlinkert/array-intersection>
 *
 * Copyright (c) 2014 Jon Schlinkert, contributors.
 * Licensed under the MIT License
 */

'use strict';

var filter = require('filter-array');
var every = require('array-every');
var unique = require('array-unique');
var slice = require('array-slice');
var indexOf = require('index-of');

module.exports = function intersection(arr) {
  if (arr == null) {
    return [];
  }

  if (arguments.length === 1) {
    return unique(arr);
  }

  var arrays = slice(arguments, 1);

  return filter(unique(arr), function (ele) {
    return every(arrays, function (cur) {
      return indexOf(cur, ele) !== -1;
    });
  });
};
