import __fs__ from 'fs';
import __path__ from 'path';
import __util__ from 'util';
import __glob__ from 'glob';
import __os__ from 'os';
import __xmlhttprequest__ from 'unxhr';

Opal.modules["corelib/file"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var $nesting = [], nil = Opal.nil, $$$ = Opal.$$$, $truthy = Opal.truthy, $klass = Opal.klass, $const_set = Opal.const_set, $Opal = Opal.Opal, $regexp = Opal.regexp, $rb_plus = Opal.rb_plus, $def = Opal.def, $Kernel = Opal.Kernel, $eqeq = Opal.eqeq, $rb_lt = Opal.rb_lt, $rb_minus = Opal.rb_minus, $range = Opal.range, $send = Opal.send, $alias = Opal.alias;

  Opal.add_stubs('respond_to?,to_path,coerce_to!,pwd,split,sub,+,unshift,join,home,raise,start_with?,absolute_path,==,<,dirname,-,basename,empty?,rindex,[],length,nil?,gsub,find,=~,map,each_with_index,flatten,reject,to_proc,end_with?');
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'File');

    var $nesting = [self].concat($parent_nesting), windows_root_rx = nil;

    
    $const_set($nesting[0], 'Separator', $const_set($nesting[0], 'SEPARATOR', "/"));
    $const_set($nesting[0], 'ALT_SEPARATOR', nil);
    $const_set($nesting[0], 'PATH_SEPARATOR', ":");
    $const_set($nesting[0], 'FNM_SYSCASE', 0);
    windows_root_rx = /^[a-zA-Z]:(?:\\|\/)/;
    return (function(self, $parent_nesting) {
      var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting);

      
      
      $def(self, '$absolute_path', function $$absolute_path(path, basedir) {
        var sep = nil, sep_chars = nil, new_parts = nil, $ret_or_1 = nil, path_abs = nil, basedir_abs = nil, parts = nil, leading_sep = nil, abs = nil, new_path = nil;

        
        
        if (basedir == null) basedir = nil;;
        sep = $$('SEPARATOR');
        sep_chars = $sep_chars();
        new_parts = [];
        path = ($truthy(path['$respond_to?']("to_path")) ? (path.$to_path()) : (path));
        path = $Opal['$coerce_to!'](path, $$$('String'), "to_str");
        basedir = ($truthy(($ret_or_1 = basedir)) ? ($ret_or_1) : ($$$('Dir').$pwd()));
        path_abs = path.substr(0, sep.length) === sep || windows_root_rx.test(path);
        basedir_abs = basedir.substr(0, sep.length) === sep || windows_root_rx.test(basedir);
        if ($truthy(path_abs)) {
          
          parts = path.$split($regexp(["[", sep_chars, "]"]));
          leading_sep = windows_root_rx.test(path) ? '' : path.$sub($regexp(["^([", sep_chars, "]+).*$"]), "\\1");
          abs = true;
        } else {
          
          parts = $rb_plus(basedir.$split($regexp(["[", sep_chars, "]"])), path.$split($regexp(["[", sep_chars, "]"])));
          leading_sep = windows_root_rx.test(basedir) ? '' : basedir.$sub($regexp(["^([", sep_chars, "]+).*$"]), "\\1");
          abs = basedir_abs;
        };
        
        var part;
        for (var i = 0, ii = parts.length; i < ii; i++) {
          part = parts[i];

          if (
            (part === nil) ||
            (part === ''  && ((new_parts.length === 0) || abs)) ||
            (part === '.' && ((new_parts.length === 0) || abs))
          ) {
            continue;
          }
          if (part === '..') {
            new_parts.pop();
          } else {
            new_parts.push(part);
          }
        }

        if (!abs && parts[0] !== '.') {
          new_parts.$unshift(".")
        }
      ;
        new_path = new_parts.$join(sep);
        if ($truthy(abs)) {
          new_path = $rb_plus(leading_sep, new_path)
        };
        return new_path;
      }, -2);
      
      $def(self, '$expand_path', function $$expand_path(path, basedir) {
        var self = this, sep = nil, sep_chars = nil, home = nil, leading_sep = nil, home_path_regexp = nil;

        
        
        if (basedir == null) basedir = nil;;
        sep = $$('SEPARATOR');
        sep_chars = $sep_chars();
        if ($truthy(path[0] === '~' || (basedir && basedir[0] === '~'))) {
          
          home = $$('Dir').$home();
          if (!$truthy(home)) {
            $Kernel.$raise($$$('ArgumentError'), "couldn't find HOME environment -- expanding `~'")
          };
          leading_sep = windows_root_rx.test(home) ? '' : home.$sub($regexp(["^([", sep_chars, "]+).*$"]), "\\1");
          if (!$truthy(home['$start_with?'](leading_sep))) {
            $Kernel.$raise($$$('ArgumentError'), "non-absolute home")
          };
          home = $rb_plus(home, sep);
          home_path_regexp = $regexp(["^\\~(?:", sep, "|$)"]);
          path = path.$sub(home_path_regexp, home);
          if ($truthy(basedir)) {
            basedir = basedir.$sub(home_path_regexp, home)
          };
        };
        return self.$absolute_path(path, basedir);
      }, -2);
      
      // Coerce a given path to a path string using #to_path and #to_str
      function $coerce_to_path(path) {
        if ($truthy((path)['$respond_to?']("to_path"))) {
          path = path.$to_path();
        }

        path = $Opal['$coerce_to!'](path, $$$('String'), "to_str");

        return path;
      }

      // Return a RegExp compatible char class
      function $sep_chars() {
        if ($$('ALT_SEPARATOR') === nil) {
          return Opal.escape_regexp($$('SEPARATOR'));
        } else {
          return Opal.escape_regexp($rb_plus($$('SEPARATOR'), $$('ALT_SEPARATOR')));
        }
      }
    ;
      
      $def(self, '$dirname', function $$dirname(path, level) {
        var self = this, sep_chars = nil;

        
        
        if (level == null) level = 1;;
        if ($eqeq(level, 0)) {
          return path
        };
        if ($truthy($rb_lt(level, 0))) {
          $Kernel.$raise($$$('ArgumentError'), "level can't be negative")
        };
        sep_chars = $sep_chars();
        path = $coerce_to_path(path);
        
        var absolute = path.match(new RegExp("^[" + (sep_chars) + "]")), out;

        path = path.replace(new RegExp("[" + (sep_chars) + "]+$"), ''); // remove trailing separators
        path = path.replace(new RegExp("[^" + (sep_chars) + "]+$"), ''); // remove trailing basename
        path = path.replace(new RegExp("[" + (sep_chars) + "]+$"), ''); // remove final trailing separators

        if (path === '') {
          out = absolute ? '/' : '.';
        }
        else {
          out = path;
        }

        if (level == 1) {
          return out;
        }
        else {
          return self.$dirname(out, $rb_minus(level, 1))
        }
      ;
      }, -2);
      
      $def(self, '$basename', function $$basename(name, suffix) {
        var sep_chars = nil;

        
        
        if (suffix == null) suffix = nil;;
        sep_chars = $sep_chars();
        name = $coerce_to_path(name);
        
        if (name.length == 0) {
          return name;
        }

        if (suffix !== nil) {
          suffix = $Opal['$coerce_to!'](suffix, $$$('String'), "to_str")
        } else {
          suffix = null;
        }

        name = name.replace(new RegExp("(.)[" + (sep_chars) + "]*$"), '$1');
        name = name.replace(new RegExp("^(?:.*[" + (sep_chars) + "])?([^" + (sep_chars) + "]+)$"), '$1');

        if (suffix === ".*") {
          name = name.replace(/\.[^\.]+$/, '');
        } else if(suffix !== null) {
          suffix = Opal.escape_regexp(suffix);
          name = name.replace(new RegExp("" + (suffix) + "$"), '');
        }

        return name;
      ;
      }, -2);
      
      $def(self, '$extname', function $$extname(path) {
        var self = this, filename = nil, last_dot_idx = nil;

        
        path = $coerce_to_path(path);
        filename = self.$basename(path);
        if ($truthy(filename['$empty?']())) {
          return ""
        };
        last_dot_idx = filename['$[]']($range(1, -1, false)).$rindex(".");
        if (($truthy(last_dot_idx['$nil?']()) || ($eqeq($rb_plus(last_dot_idx, 1), $rb_minus(filename.$length(), 1))))) {
          return ""
        } else {
          return filename['$[]'](Opal.Range.$new($rb_plus(last_dot_idx, 1), -1, false))
        };
      }, 1);
      
      $def(self, '$exist?', function $exist$ques$1(path) {
        
        return Opal.modules[path] != null
      }, 1);
      
      $def(self, '$directory?', function $directory$ques$2(path) {
        var files = nil, file = nil;

        
        files = [];
        
        for (var key in Opal.modules) {
          files.push(key)
        }
      ;
        path = path.$gsub($regexp(["(^.", $$('SEPARATOR'), "+|", $$('SEPARATOR'), "+$)"]));
        file = $send(files, 'find', [], function $$3(f){
          
          
          if (f == null) f = nil;;
          return f['$=~']($regexp(["^", path]));}, 1);
        return file;
      }, 1);
      
      $def(self, '$join', function $$join($a) {
        var $post_args, paths, result = nil;

        
        
        $post_args = Opal.slice.call(arguments);
        
        paths = $post_args;;
        if ($truthy(paths['$empty?']())) {
          return ""
        };
        result = "";
        paths = $send(paths.$flatten().$each_with_index(), 'map', [], function $$4(item, index){
          
          
          if (item == null) item = nil;;
          
          if (index == null) index = nil;;
          if (($eqeq(index, 0) && ($truthy(item['$empty?']())))) {
            return $$('SEPARATOR')
          } else if (($eqeq(paths.$length(), $rb_plus(index, 1)) && ($truthy(item['$empty?']())))) {
            return $$('SEPARATOR')
          } else {
            return item
          };}, 2);
        paths = $send(paths, 'reject', [], "empty?".$to_proc());
        $send(paths, 'each_with_index', [], function $$5(item, index){var next_item = nil;

          
          
          if (item == null) item = nil;;
          
          if (index == null) index = nil;;
          next_item = paths['$[]']($rb_plus(index, 1));
          if ($truthy(next_item['$nil?']())) {
            return (result = "" + (result) + (item))
          } else {
            
            if (($truthy(item['$end_with?']($$('SEPARATOR'))) && ($truthy(next_item['$start_with?']($$('SEPARATOR')))))) {
              item = item.$sub($regexp([$$('SEPARATOR'), "+$"]), "")
            };
            return (result = (($truthy(item['$end_with?']($$('SEPARATOR'))) || ($truthy(next_item['$start_with?']($$('SEPARATOR'))))) ? ("" + (result) + (item)) : ("" + (result) + (item) + ($$('SEPARATOR')))));
          };}, 2);
        return result;
      }, -1);
      
      $def(self, '$split', function $$split(path) {
        
        return path.$split($$('SEPARATOR'))
      }, 1);
      $alias(self, "realpath", "expand_path");
      return $alias(self, "exists?", "exist?");
    })(Opal.get_singleton_class(self), $nesting);
  })('::', $$$('IO'), $nesting)
};

Opal.modules["nodejs/file"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var self = Opal.top, $nesting = [], $$ = Opal.$r($nesting), nil = Opal.nil, $$$ = Opal.$$$, $klass = Opal.klass, $truthy = Opal.truthy, $const_set = Opal.const_set, $defs = Opal.defs, $alias = Opal.alias, $send = Opal.send, $neqeq = Opal.neqeq, $send2 = Opal.send2, $find_super = Opal.find_super, $def = Opal.def;

  Opal.add_stubs('require,constants,raise,warn,const_get,new,error,size,respond_to?,path,join,call,start_with?,first,exist?,realpath,!=,close,to_path,pwd,to_str,include?,delete,match?,sub,attr_reader');
  
  self.$require("corelib/file");
  
  var warnings = {}, errno_codes = $$('Errno').$constants();

  function handle_unsupported_feature(message) {
    switch (Opal.config.unsupported_features_severity) {
    case 'error':
      $$('Kernel').$raise($$('NotImplementedError'), message)
      break;
    case 'warning':
      warn(message)
      break;
    default: // ignore
      // noop
    }
  }
  function warn(string) {
    if (warnings[string]) {
      return;
    }
    warnings[string] = true;
    self.$warn(string);
  }
  function is_utf8(bytes) {
    var i = 0;
    while (i < bytes.length) {
      if ((// ASCII
        bytes[i] === 0x09 ||
        bytes[i] === 0x0A ||
        bytes[i] === 0x0D ||
        (0x20 <= bytes[i] && bytes[i] <= 0x7E)
      )
      ) {
        i += 1;
        continue;
      }

      if ((// non-overlong 2-byte
        (0xC2 <= bytes[i] && bytes[i] <= 0xDF) &&
        (0x80 <= bytes[i + 1] && bytes[i + 1] <= 0xBF)
      )
      ) {
        i += 2;
        continue;
      }

      if ((// excluding overlongs
          bytes[i] === 0xE0 &&
          (0xA0 <= bytes[i + 1] && bytes[i + 1] <= 0xBF) &&
          (0x80 <= bytes[i + 2] && bytes[i + 2] <= 0xBF)
        ) ||
        (// straight 3-byte
          ((0xE1 <= bytes[i] && bytes[i] <= 0xEC) ||
            bytes[i] === 0xEE ||
            bytes[i] === 0xEF) &&
          (0x80 <= bytes[i + 1] && bytes[i + 1] <= 0xBF) &&
          (0x80 <= bytes[i + 2] && bytes[i + 2] <= 0xBF)
        ) ||
        (// excluding surrogates
          bytes[i] === 0xED &&
          (0x80 <= bytes[i + 1] && bytes[i + 1] <= 0x9F) &&
          (0x80 <= bytes[i + 2] && bytes[i + 2] <= 0xBF)
        )
      ) {
        i += 3;
        continue;
      }

      if ((// planes 1-3
          bytes[i] === 0xF0 &&
          (0x90 <= bytes[i + 1] && bytes[i + 1] <= 0xBF) &&
          (0x80 <= bytes[i + 2] && bytes[i + 2] <= 0xBF) &&
          (0x80 <= bytes[i + 3] && bytes[i + 3] <= 0xBF)
        ) ||
        (// planes 4-15
          (0xF1 <= bytes[i] && bytes[i] <= 0xF3) &&
          (0x80 <= bytes[i + 1] && bytes[i + 1] <= 0xBF) &&
          (0x80 <= bytes[i + 2] && bytes[i + 2] <= 0xBF) &&
          (0x80 <= bytes[i + 3] && bytes[i + 3] <= 0xBF)
        ) ||
        (// plane 16
          bytes[i] === 0xF4 &&
          (0x80 <= bytes[i + 1] && bytes[i + 1] <= 0x8F) &&
          (0x80 <= bytes[i + 2] && bytes[i + 2] <= 0xBF) &&
          (0x80 <= bytes[i + 3] && bytes[i + 3] <= 0xBF)
        )
      ) {
        i += 4;
        continue;
      }

      return false;
    }

    return true;
  }
  function executeIOAction(action) {
    try {
      return action();
    } catch (error) {
      if (errno_codes.indexOf(error.code) >= 0) {
        var error_class = $$('Errno').$const_get(error.code)
        $$('Kernel').$raise((error_class).$new(error.message))
      }
      $$('Kernel').$raise(self.$error())
    }
  }
;
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'File');

    var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting), $proto = self.$$prototype;
    if (self.__fs__ == null) self.__fs__ = nil;
    if (self.__path__ == null) self.__path__ = nil;
    if (self.__util__ == null) self.__util__ = nil;

    $proto.eof = $proto.binary_flag = $proto.path = $proto.fd = nil;
    
    self.__fs__ = __fs__;
    self.__path__ = __path__;
    self.__util__ = __util__;
    var __TextEncoder__ = typeof TextEncoder !== 'undefined' ? TextEncoder : __util__.TextEncoder;
    var __TextDecoder__ = typeof TextDecoder !== 'undefined' ? TextDecoder : __util__.TextDecoder;
    var __utf8TextDecoder__ = new __TextDecoder__('utf8');
    var __textEncoder__ = new __TextEncoder__();
    if ($truthy(__path__.sep !== $$('Separator'))) {
      $const_set($nesting[0], 'ALT_SEPARATOR', __path__.sep)
    };
    $defs(self, '$read', function $$read(path) {
      
      return executeIOAction(function(){return __fs__.readFileSync(path).toString()})
    }, 1);
    $defs(self, '$write', function $$write(path, data) {
      
      
      executeIOAction(function(){return __fs__.writeFileSync(path, data)});
      return data.$size();
    }, 2);
    $defs(self, '$delete', function $File_delete$1(path) {
      
      return executeIOAction(function(){return __fs__.unlinkSync(path)})
    }, 1);
    (function(self, $parent_nesting) {
      
      return $alias(self, "unlink", "delete")
    })(Opal.get_singleton_class(self), $nesting);
    $defs(self, '$exist?', function $File_exist$ques$2(path) {
      
      
      if ($truthy(path['$respond_to?']("path"))) {
        path = path.$path()
      };
      return executeIOAction(function(){return __fs__.existsSync(path)});
    }, 1);
    $defs(self, '$realpath', function $$realpath(pathname, dir_string, cache) {
      var block = $$realpath.$$p || nil, self = this;

      delete $$realpath.$$p;
      
      ;
      
      if (dir_string == null) dir_string = nil;;
      
      if (cache == null) cache = nil;;
      if ($truthy(dir_string)) {
        pathname = self.$join(dir_string, pathname)
      };
      if ((block !== nil)) {
        
        __fs__.realpath(pathname, cache, function(error, realpath){
          if (error) Opal.IOError.$new(error.message)
          else block.$call(realpath)
        })
        
      } else {
        return executeIOAction(function(){return __fs__.realpathSync(pathname, cache)})
      };
    }, -2);
    $defs(self, '$join', function $$join($a) {
      var $post_args, paths, $b, prefix = nil;

      
      
      $post_args = Opal.slice.call(arguments);
      
      paths = $post_args;;
      prefix = ($truthy(($b = paths.$first(), ($b === nil || $b == null) ? nil : $send($b, 'start_with?', ["//"]))) ? ("/") : (""));
      return prefix + __path__.posix.join.apply(__path__, paths);
    }, -1);
    $defs(self, '$directory?', function $File_directory$ques$3(path) {
      var self = this, result = nil, realpath = nil;

      
      if (!$truthy(self['$exist?'](path))) {
        return false
      };
      result = executeIOAction(function(){return !!__fs__.lstatSync(path).isDirectory()});
      if (!$truthy(result)) {
        
        realpath = self.$realpath(path);
        if ($neqeq(realpath, path)) {
          result = executeIOAction(function(){return !!__fs__.lstatSync(realpath).isDirectory()})
        };
      };
      return result;
    }, 1);
    $defs(self, '$file?', function $File_file$ques$4(path) {
      var self = this, result = nil, realpath = nil;

      
      if (!$truthy(self['$exist?'](path))) {
        return false
      };
      result = executeIOAction(function(){return !!__fs__.lstatSync(path).isFile()});
      if (!$truthy(result)) {
        
        realpath = self.$realpath(path);
        if ($neqeq(realpath, path)) {
          result = executeIOAction(function(){return !!__fs__.lstatSync(realpath).isFile()})
        };
      };
      return result;
    }, 1);
    $defs(self, '$readable?', function $File_readable$ques$5(path) {
      var self = this;

      
      if (!$truthy(self['$exist?'](path))) {
        return false
      };
      return "\n" + "        try {\n" + "          __fs__.accessSync(path, __fs__.R_OK);\n" + "          return true;\n" + "        } catch (error) {\n" + "          return false;\n" + "        }\n" + "      ";
    }, 1);
    $defs(self, '$size', function $$size(path) {
      
      return executeIOAction(function(){return __fs__.lstatSync(path).size});
    }, 1);
    $defs(self, '$open', function $$open(path, mode) {
      var $yield = $$open.$$p || nil, self = this, file = nil;

      delete $$open.$$p;
      
      
      if (mode == null) mode = "r";;
      file = self.$new(path, mode);
      if (($yield !== nil)) {
        
        return (function() { try {
        return Opal.yield1($yield, file);
        } finally {
          file.$close()
        }; })();
      } else {
        return file
      };
    }, -2);
    $defs(self, '$stat', function $$stat(path) {
      
      
      if ($truthy(path['$respond_to?']("path"))) {
        path = path.$path()
      };
      return $$$($$('File'), 'Stat').$new(path);
    }, 1);
    $defs(self, '$mtime', function $$mtime(path) {
      
      return executeIOAction(function(){return __fs__.statSync(path).mtime})
    }, 1);
    $defs(self, '$symlink?', function $File_symlink$ques$6(path) {
      
      return executeIOAction(function(){return __fs__.lstatSync(path).isSymbolicLink()})
    }, 1);
    $defs(self, '$absolute_path', function $$absolute_path(path, basedir) {
      var $ret_or_1 = nil;

      
      
      if (basedir == null) basedir = nil;;
      path = ($truthy(path['$respond_to?']("to_path")) ? (path.$to_path()) : (path));
      basedir = ($truthy(($ret_or_1 = basedir)) ? ($ret_or_1) : ($$('Dir').$pwd()));
      return __path__.normalize(__path__.resolve(basedir.$to_str(), path.$to_str())).split(__path__.sep).join(__path__.posix.sep);
    }, -2);
    
    $def(self, '$initialize', function $$initialize(path, flags) {
      var $yield = $$initialize.$$p || nil, self = this, encoding_option_rx = nil, fd = nil;

      delete $$initialize.$$p;
      
      
      if (flags == null) flags = "r";;
      self.binary_flag = flags['$include?']("b");
      flags = flags.$delete("b");
      encoding_option_rx = /:(.*)/;
      if ($truthy(encoding_option_rx['$match?'](flags))) {
        
        handle_unsupported_feature("Encoding option (:encoding) is unsupported by Node.js openSync method and will be removed.");
        flags = flags.$sub(encoding_option_rx, "");
      };
      self.path = path;
      fd = executeIOAction(function(){return __fs__.openSync(path, flags)});
      return $send2(self, $find_super(self, 'initialize', $$initialize, false, true), 'initialize', [fd, flags], null);
    }, -2);
    self.$attr_reader("path");
    
    $def(self, '$sysread', function $$sysread(bytes) {
      var self = this, res = nil;

      if ($truthy(self.eof)) {
        return self.$raise($$('EOFError'), "end of file reached")
      } else {
        
        if ($truthy(self.binary_flag)) {
          
          
          var buf = executeIOAction(function(){return __fs__.readFileSync(self.path)})
          var content
          if (is_utf8(buf)) {
            content = buf.toString('utf8')
          } else {
            // coerce to utf8
            content = __utf8TextDecoder__.decode(__textEncoder__.encode(buf.toString('binary')))
          }
        ;
          res = content;
        } else {
          res = executeIOAction(function(){return __fs__.readFileSync(self.path).toString('utf8')})
        };
        self.eof = true;
        self.lineno = res.$size();
        return res;
      }
    }, 1);
    
    $def(self, '$write', function $$write(string) {
      var self = this;

      return executeIOAction(function(){return __fs__.writeSync(self.fd, string)})
    }, 1);
    
    $def(self, '$flush', function $$flush() {
      var self = this;

      return executeIOAction(function(){return __fs__.fsyncSync(self.fd)})
    }, 0);
    
    $def(self, '$close', function $$close() {
      var $yield = $$close.$$p || nil, self = this;

      delete $$close.$$p;
      
      executeIOAction(function(){return __fs__.closeSync(self.fd)});
      return $send2(self, $find_super(self, 'close', $$close, false, true), 'close', [], $yield);
    }, 0);
    return $def(self, '$mtime', function $$mtime() {
      var self = this;

      return executeIOAction(function(){return __fs__.statSync(self.path).mtime})
    }, 0);
  })($nesting[0], $$('IO'), $nesting);
  return (function($base, $super) {
    var self = $klass($base, $super, 'Stat');

    var $proto = self.$$prototype;
    if (self.__fs__ == null) self.__fs__ = nil;

    $proto.path = nil;
    
    self.__fs__ = __fs__;
    
    $def(self, '$initialize', function $$initialize(path) {
      var self = this;

      return (self.path = path)
    }, 1);
    
    $def(self, '$file?', function $Stat_file$ques$7() {
      var self = this;

      return executeIOAction(function(){return __fs__.statSync(self.path).isFile()})
    }, 0);
    
    $def(self, '$directory?', function $Stat_directory$ques$8() {
      var self = this;

      return executeIOAction(function(){return __fs__.statSync(self.path).isDirectory()})
    }, 0);
    
    $def(self, '$mtime', function $$mtime() {
      var self = this;

      return executeIOAction(function(){return __fs__.statSync(self.path).mtime})
    }, 0);
    
    $def(self, '$readable?', function $Stat_readable$ques$9() {
      var self = this;

      return executeIOAction(function(){return __fs__.accessSync(self.path, __fs__.constants.R_OK)})
    }, 0);
    
    $def(self, '$writable?', function $Stat_writable$ques$10() {
      var self = this;

      return executeIOAction(function(){return __fs__.accessSync(self.path, __fs__.constants.W_OK)})
    }, 0);
    return $def(self, '$executable?', function $Stat_executable$ques$11() {
      var self = this;

      return executeIOAction(function(){return __fs__.accessSync(self.path, __fs__.constants.X_OK)})
    }, 0);
  })($$('File'), null);
};

Opal.modules["nodejs/dir"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var $nesting = [], nil = Opal.nil, $klass = Opal.klass, $def = Opal.def, $truthy = Opal.truthy, $send = Opal.send, $Opal = Opal.Opal, $alias = Opal.alias;

  Opal.add_stubs('respond_to?,flat_map,to_path,coerce_to!');
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Dir');

    var $nesting = [self].concat($parent_nesting);
    if (self.__glob__ == null) self.__glob__ = nil;
    if (self.__fs__ == null) self.__fs__ = nil;
    if (self.__path__ == null) self.__path__ = nil;
    if (self.__os__ == null) self.__os__ = nil;

    
    self.__glob__ = __glob__;
    self.__fs__ = __fs__;
    self.__path__ = __path__;
    self.__os__ = __os__;
    return (function(self, $parent_nesting) {
      var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting);

      
      
      $def(self, '$[]', function $$$1(glob) {
        
        return __glob__.sync(glob)
      }, 1);
      
      $def(self, '$pwd', function $$pwd() {
        
        return process.cwd().split(__path__.sep).join(__path__.posix.sep);
      }, 0);
      
      $def(self, '$home', function $$home() {
        
        return __os__.homedir();
      }, 0);
      
      $def(self, '$chdir', function $$chdir(path) {
        
        return process.chdir(path)
      }, 1);
      
      $def(self, '$mkdir', function $$mkdir(path) {
        
        return __fs__.mkdirSync(path)
      }, 1);
      
      $def(self, '$entries', function $$entries(dirname) {
        
        
        var result = [];
        var entries = __fs__.readdirSync(dirname);
        for (var i = 0, ii = entries.length; i < ii; i++) {
          result.push(entries[i]);
        }
        return result;
      
      }, 1);
      
      $def(self, '$glob', function $$glob(pattern) {
        
        
        if (!$truthy(pattern['$respond_to?']("each"))) {
          pattern = [pattern]
        };
        return $send(pattern, 'flat_map', [], function $$2(subpattern){
          
          
          if (subpattern == null) subpattern = nil;;
          if ($truthy(subpattern['$respond_to?']("to_path"))) {
            subpattern = subpattern.$to_path()
          };
          subpattern = $Opal['$coerce_to!'](subpattern, $$('String'), "to_str");
          return __glob__.sync(subpattern);;}, 1);
      }, 1);
      return $alias(self, "getwd", "pwd");
    })(Opal.get_singleton_class(self), $nesting);
  })($nesting[0], null, $nesting)
};

Opal.modules["nodejs/io"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var self = Opal.top, $nesting = [], nil = Opal.nil, $klass = Opal.klass, $alias = Opal.alias, $def = Opal.def, $defs = Opal.defs;

  Opal.add_stubs('require,attr_reader,initialize_before_node_io,write,read');
  
  self.$require("nodejs/file");
  
  function executeIOAction(action) {
    try {
      return action();
    } catch (error) {
      if (error.code === 'EACCES' ||
          error.code === 'EISDIR' ||
          error.code === 'EMFILE' ||
          error.code === 'ENOENT' ||
          error.code === 'EPERM') {
        throw Opal.IOError.$new(error.message)
      }
      throw error;
    }
  }
;
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'IO');

    var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting);

    
    self.__fs__ = __fs__;
    self.$attr_reader("lineno");
    $alias(self, "initialize_before_node_io", "initialize");
    
    $def(self, '$initialize', function $$initialize(fd, flags) {
      var self = this;

      
      
      if (flags == null) flags = "r";;
      self.lineno = 0;
      return self.$initialize_before_node_io(fd, flags);
    }, -2);
    $defs(self, '$write', function $$write(path, data) {
      
      return $$('File').$write(path, data)
    }, 2);
    $defs(self, '$read', function $$read(path) {
      
      return $$('File').$read(path)
    }, 1);
    return $defs(self, '$binread', function $$binread(path) {
      
      return executeIOAction(function(){return __fs__.readFileSync(path).toString('binary')})
    }, 1);
  })($nesting[0], null, $nesting);
};

Opal.modules["nodejs/argf"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var $nesting = [], $$ = Opal.$r($nesting), nil = Opal.nil, $const_set = Opal.const_set, $def = Opal.def, $eqeq = Opal.eqeq, $gvars = Opal.gvars, $truthy = Opal.truthy, $send = Opal.send, $to_a = Opal.to_a, $rb_plus = Opal.rb_plus, $rb_minus = Opal.rb_minus, $rb_gt = Opal.rb_gt, $not = Opal.not, $alias = Opal.alias, $writer = nil;

  Opal.add_stubs('new,include,filename,==,open,argv,shift,close,file,closed?,enum_for,gets,nil?,+,loop,read,-,length,>,to_a,each,attr_accessor,rewind,!,fileno,eof?,lineno=');
  
  $const_set($nesting[0], 'ARGF', $$('Object').$new());
  (function(self, $parent_nesting) {
    var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting);

    
    self.$include($$('Enumerable'));
    
    $def(self, '$inspect', function $$inspect() {
      
      return "ARGF"
    }, 0);
    
    $def(self, '$argv', function $$argv() {
      
      return $$('ARGV')
    }, 0);
    
    $def(self, '$file', function $$file() {
      var self = this, fn = nil, $ret_or_1 = nil;
      if (self.file == null) self.file = nil;
      if ($gvars.stdin == null) $gvars.stdin = nil;

      
      fn = self.$filename();
      if ($eqeq(fn, "-")) {
        return $gvars.stdin
      } else {
        return (self.file = ($truthy(($ret_or_1 = self.file)) ? ($ret_or_1) : ($$('File').$open(fn, "r"))))
      };
    }, 0);
    
    $def(self, '$filename', function $$filename() {
      var self = this, $ret_or_1 = nil;
      if (self.filename == null) self.filename = nil;
      if (self.last_filename == null) self.last_filename = nil;

      
      if ($truthy(self.filename)) {
        return self.filename
      };
      if ($eqeq(self.$argv(), ["-"])) {
        return "-"
      } else if ($eqeq(self.$argv(), [])) {
        if ($truthy(($ret_or_1 = self.last_filename))) {
          return $ret_or_1
        } else {
          return "-"
        }
      } else {
        
        self.file = nil;
        return (self.filename = (self.last_filename = self.$argv().$shift()));
      };
    }, 0);
    
    $def(self, '$close', function $$close() {
      var self = this;

      
      self.$file().$close();
      self.filename = nil;
      return self;
    }, 0);
    
    $def(self, '$closed?', function $closed$ques$1() {
      var self = this;

      return self.$file()['$closed?']()
    }, 0);
    
    $def(self, '$each', function $$each($a) {
      var block = $$each.$$p || nil, $post_args, args, $b, self = this, l = nil;

      delete $$each.$$p;
      
      ;
      
      $post_args = Opal.slice.call(arguments);
      
      args = $post_args;;
      if (!(block !== nil)) {
        return self.$enum_for("each")
      };
      while ($truthy((l = $send(self, 'gets', $to_a(args))))) {
        Opal.yield1(block, l)
      };
    }, -1);
    
    $def(self, '$gets', function $$gets($a) {
      var $post_args, args, self = this, s = nil;
      if (self.lineno == null) self.lineno = nil;

      
      
      $post_args = Opal.slice.call(arguments);
      
      args = $post_args;;
      s = $send(self.$file(), 'gets', $to_a(args));
      if ($truthy(s['$nil?']())) {
        
        self.$close();
        s = $send(self.$file(), 'gets', $to_a(args));
      };
      if ($truthy(s)) {
        self.lineno = $rb_plus(self.lineno, 1)
      };
      return s;
    }, -1);
    
    $def(self, '$read', function $$read(len) {
      var self = this, buf = nil;

      
      
      if (len == null) len = nil;;
      buf = "";
      return (function(){var $brk = Opal.new_brk(); try {return $send(self, 'loop', [], function $$2(){var self = $$2.$$s == null ? this : $$2.$$s, r = nil;
        if (self.filename == null) self.filename = nil;

        
        r = self.$file().$read(len);
        if ($truthy(r)) {
          
          buf = $rb_plus(buf, r);
          len = $rb_minus(len, r.$length());
        };
        self.$file().$close();
        if ((($truthy(len) && ($truthy($rb_gt(len, 0)))) && ($truthy(self.filename)))) {
          
          Opal.brk(nil, $brk)
        } else {
          return nil
        };}, {$$arity: 0, $$s: self, $$brk: $brk})
      } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();
    }, -1);
    
    $def(self, '$readlines', function $$readlines($a) {
      var $post_args, args, self = this;

      
      
      $post_args = Opal.slice.call(arguments);
      
      args = $post_args;;
      return $send(self, 'each', $to_a(args)).$to_a();
    }, -1);
    self.$attr_accessor("lineno");
    
    $def(self, '$rewind', function $$rewind() {
      var self = this, f = nil;

      
      self.lineno = 1;
      f = self.$file();
      
      try {
        f.$rewind()
      } catch ($err) {
        if (Opal.rescue($err, [$$('StandardError')])) {
          try {
            nil
          } finally { Opal.pop_exception(); }
        } else { throw $err; }
      };;
      return 0;
    }, 0);
    
    $def(self, '$fileno', function $$fileno() {
      var self = this;
      if (self.last_filename == null) self.last_filename = nil;
      if (self.filename == null) self.filename = nil;

      
      if (($not(self.filename) && ($truthy(self.last_filename)))) {
        return 0
      };
      return self.$file().$fileno();
    }, 0);
    
    $def(self, '$eof?', function $eof$ques$3() {
      var self = this;

      return self.$file()['$eof?']()
    }, 0);
    $alias(self, "each_line", "each");
    $alias(self, "eof", "eof?");
    $alias(self, "path", "filename");
    $alias(self, "skip", "close");
    $alias(self, "to_i", "fileno");
    return $alias(self, "to_io", "file");
  })(Opal.get_singleton_class($$('ARGF')), $nesting);
  
  $writer = [1];
  $send($$('ARGF'), 'lineno=', $to_a($writer));
  return $writer[$rb_minus($writer["length"], 1)];;
};

Opal.modules["nodejs/open-uri"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var $nesting = [], nil = Opal.nil, $module = Opal.module, $defs = Opal.defs;

  return (function($base) {
    var self = $module($base, 'OpenURI');

        if (self.__xmlhttprequest__ == null) self.__xmlhttprequest__ = nil;

    
    self.__xmlhttprequest__ = __xmlhttprequest__;
    var __XMLHttpRequest__ = self.__xmlhttprequest__.XMLHttpRequest;
    $defs(self, '$request', function $$request(uri) {
      
      
      var xhr = new __XMLHttpRequest__();
      xhr.open('GET', uri, false);
      xhr.responseType = 'arraybuffer';
      xhr.send();
      return xhr;
    
    }, 1);
    return $defs(self, '$data', function $$data(req) {
      
      
      var arrayBuffer = req.response;
      var byteArray = new Uint8Array(arrayBuffer);
      var result = []
      for (var i = 0; i < byteArray.byteLength; i++) {
        result.push(byteArray[i]);
      }
      return result;
    
    }, 1);
  })($nesting[0])
};

Opal.modules["corelib/comparable"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var nil = Opal.nil, $$$ = Opal.$$$, $truthy = Opal.truthy, $module = Opal.module, $rb_gt = Opal.rb_gt, $rb_lt = Opal.rb_lt, $eqeqeq = Opal.eqeqeq, $Kernel = Opal.Kernel, $def = Opal.def;

  Opal.add_stubs('>,<,===,raise,class,<=>,equal?');
  return (function($base) {
    var self = $module($base, 'Comparable');

    var $ret_or_1 = nil;

    
    
    function normalize(what) {
      if (Opal.is_a(what, Opal.Integer)) { return what; }

      if ($rb_gt(what, 0)) { return 1; }
      if ($rb_lt(what, 0)) { return -1; }
      return 0;
    }

    function fail_comparison(lhs, rhs) {
      var class_name;
      (($eqeqeq(nil, ($ret_or_1 = rhs)) || (($eqeqeq(true, $ret_or_1) || (($eqeqeq(false, $ret_or_1) || (($eqeqeq($$$('Integer'), $ret_or_1) || ($eqeqeq($$$('Float'), $ret_or_1))))))))) ? (class_name = rhs.$inspect()) : (class_name = rhs.$$class))
      $Kernel.$raise($$$('ArgumentError'), "comparison of " + ((lhs).$class()) + " with " + (class_name) + " failed")
    }

    function cmp_or_fail(lhs, rhs) {
      var cmp = (lhs)['$<=>'](rhs);
      if (!$truthy(cmp)) fail_comparison(lhs, rhs);
      return normalize(cmp);
    }
  ;
    
    $def(self, '$==', function $Comparable_$eq_eq$1(other) {
      var self = this, cmp = nil;

      
      if ($truthy(self['$equal?'](other))) {
        return true
      };
      
      if (self["$<=>"] == Opal.Kernel["$<=>"]) {
        return false;
      }

      // check for infinite recursion
      if (self.$$comparable) {
        delete self.$$comparable;
        return false;
      }
    ;
      if (!$truthy((cmp = self['$<=>'](other)))) {
        return false
      };
      return normalize(cmp) == 0;;
    }, 1);
    
    $def(self, '$>', function $Comparable_$gt$2(other) {
      var self = this;

      return cmp_or_fail(self, other) > 0;
    }, 1);
    
    $def(self, '$>=', function $Comparable_$gt_eq$3(other) {
      var self = this;

      return cmp_or_fail(self, other) >= 0;
    }, 1);
    
    $def(self, '$<', function $Comparable_$lt$4(other) {
      var self = this;

      return cmp_or_fail(self, other) < 0;
    }, 1);
    
    $def(self, '$<=', function $Comparable_$lt_eq$5(other) {
      var self = this;

      return cmp_or_fail(self, other) <= 0;
    }, 1);
    
    $def(self, '$between?', function $Comparable_between$ques$6(min, max) {
      var self = this;

      
      if ($rb_lt(self, min)) {
        return false
      };
      if ($rb_gt(self, max)) {
        return false
      };
      return true;
    }, 2);
    return $def(self, '$clamp', function $$clamp(min, max) {
      var self = this;

      
      
      if (max == null) max = nil;;
      
      var c, excl;

      if (max === nil) {
        // We are dealing with a new Ruby 2.7 behaviour that we are able to
        // provide a single Range argument instead of 2 Comparables.

        if (!Opal.is_a(min, Opal.Range)) {
          $Kernel.$raise($$$('TypeError'), "wrong argument type " + (min.$class()) + " (expected Range)")
        }

        excl = min.excl;
        max = min.end;
        min = min.begin;

        if (max !== nil && excl) {
          $Kernel.$raise($$$('ArgumentError'), "cannot clamp with an exclusive range")
        }
      }

      if (min !== nil && max !== nil && cmp_or_fail(min, max) > 0) {
        $Kernel.$raise($$$('ArgumentError'), "min argument must be smaller than max argument")
      }

      if (min !== nil) {
        c = cmp_or_fail(self, min);

        if (c == 0) return self;
        if (c < 0) return min;
      }

      if (max !== nil) {
        c = cmp_or_fail(self, max);

        if (c > 0) return max;
      }

      return self;
    ;
    }, -2);
  })('::')
};

Opal.modules["pathname"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.$$$, $klass = Opal.klass, $const_set = Opal.const_set, $regexp = Opal.regexp, $eqeqeq = Opal.eqeqeq, $truthy = Opal.truthy, $eqeq = Opal.eqeq, $def = Opal.def, $defs = Opal.defs, $to_ary = Opal.to_ary, $send = Opal.send, $to_a = Opal.to_a, $neqeq = Opal.neqeq, $rb_plus = Opal.rb_plus, $not = Opal.not, $alias = Opal.alias, $module = Opal.module;

  Opal.add_stubs('require,include,quote,===,to_s,path,respond_to?,to_path,is_a?,nil?,raise,class,==,new,pwd,attr_reader,!,relative?,chop_basename,basename,=~,source,[],rindex,sub,absolute?,expand_path,plus,unshift,length,!=,empty?,first,shift,+,join,dirname,pop,reverse_each,directory?,extname,<=>,nonzero?,proc,casecmp,cleanpath,inspect,include?,fill,map,entries');
  
  self.$require("corelib/comparable");
  (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Pathname');

    var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting), $proto = self.$$prototype;

    $proto.path = nil;
    
    self.$include($$('Comparable'));
    $const_set($nesting[0], 'SEPARATOR_PAT', $regexp([$$('Regexp').$quote($$$($$('File'), 'SEPARATOR'))]));
    
    $def(self, '$initialize', function $$initialize(path) {
      var self = this;

      
      if ($eqeqeq($$('Pathname'), path)) {
        self.path = path.$path().$to_s()
      } else if ($truthy(path['$respond_to?']("to_path"))) {
        self.path = path.$to_path()
      } else if ($truthy(path['$is_a?']($$('String')))) {
        self.path = path
      } else if ($truthy(path['$nil?']())) {
        self.$raise($$('TypeError'), "no implicit conversion of nil into String")
      } else {
        self.$raise($$('TypeError'), "no implicit conversion of " + (path.$class()) + " into String")
      };
      if ($eqeq(self.path, "\u0000")) {
        return self.$raise($$('ArgumentError'))
      } else {
        return nil
      };
    }, 1);
    $defs(self, '$pwd', function $$pwd() {
      var self = this;

      return self.$new($$('Dir').$pwd())
    }, 0);
    self.$attr_reader("path");
    
    $def(self, '$==', function $Pathname_$eq_eq$1(other) {
      var self = this;

      return other.$path()['$=='](self.path)
    }, 1);
    
    $def(self, '$absolute?', function $Pathname_absolute$ques$2() {
      var self = this;

      return self['$relative?']()['$!']()
    }, 0);
    
    $def(self, '$relative?', function $Pathname_relative$ques$3() {
      var $a, $b, $c, self = this, path = nil, r = nil;

      
      path = self.path;
      while ($truthy((r = self.$chop_basename(path)))) {
        $c = r, $b = $to_ary($c), (path = ($b[0] == null ? nil : $b[0])), $c
      };
      return path['$==']("");
    }, 0);
    
    $def(self, '$chop_basename', function $$chop_basename(path) {
      var base = nil;

      
      base = $$('File').$basename(path);
      if ($truthy($$('Regexp').$new("^" + ($$$($$('Pathname'), 'SEPARATOR_PAT').$source()) + "?$")['$=~'](base))) {
        return nil
      } else {
        return [path['$[]'](0, path.$rindex(base)), base]
      };
    }, 1);
    
    $def(self, '$root?', function $Pathname_root$ques$4() {
      var self = this;

      return self.path['$==']("/")
    }, 0);
    
    $def(self, '$parent', function $$parent() {
      var self = this, new_path = nil;

      
      new_path = self.path.$sub(/\/([^\/]+\/?$)/, "");
      if ($eqeq(new_path, "")) {
        new_path = ($truthy(self['$absolute?']()) ? ("/") : ("."))
      };
      return $$('Pathname').$new(new_path);
    }, 0);
    
    $def(self, '$sub', function $$sub($a) {
      var $post_args, args, self = this;

      
      
      $post_args = Opal.slice.call(arguments);
      
      args = $post_args;;
      return $$('Pathname').$new($send(self.path, 'sub', $to_a(args)));
    }, -1);
    
    $def(self, '$cleanpath', function $$cleanpath() {
      var self = this;

      return Opal.normalize(self.path)
    }, 0);
    
    $def(self, '$to_path', function $$to_path() {
      var self = this;

      return self.path
    }, 0);
    
    $def(self, '$hash', function $$hash() {
      var self = this;

      return self.path
    }, 0);
    
    $def(self, '$expand_path', function $$expand_path() {
      var self = this;

      return $$('Pathname').$new($$('File').$expand_path(self.path))
    }, 0);
    
    $def(self, '$+', function $Pathname_$plus$5(other) {
      var self = this;

      
      if (!$eqeqeq($$('Pathname'), other)) {
        other = $$('Pathname').$new(other)
      };
      return $$('Pathname').$new(self.$plus(self.path, other.$to_s()));
    }, 1);
    
    $def(self, '$plus', function $$plus(path1, path2) {
      var $a, $b, $c, self = this, prefix2 = nil, index_list2 = nil, basename_list2 = nil, r2 = nil, basename2 = nil, prefix1 = nil, $ret_or_1 = nil, r1 = nil, basename1 = nil, suffix2 = nil;

      
      prefix2 = path2;
      index_list2 = [];
      basename_list2 = [];
      while ($truthy((r2 = self.$chop_basename(prefix2)))) {
        
        $c = r2, $b = $to_ary($c), (prefix2 = ($b[0] == null ? nil : $b[0])), (basename2 = ($b[1] == null ? nil : $b[1])), $c;
        index_list2.$unshift(prefix2.$length());
        basename_list2.$unshift(basename2);
      };
      if ($neqeq(prefix2, "")) {
        return path2
      };
      prefix1 = path1;
      while ($truthy(true)) {
        
        while ($truthy(($truthy(($ret_or_1 = basename_list2['$empty?']()['$!']())) ? (basename_list2.$first()['$=='](".")) : ($ret_or_1)))) {
          
          index_list2.$shift();
          basename_list2.$shift();
        };
        if (!$truthy((r1 = self.$chop_basename(prefix1)))) {
          break;
        };
        $c = r1, $b = $to_ary($c), (prefix1 = ($b[0] == null ? nil : $b[0])), (basename1 = ($b[1] == null ? nil : $b[1])), $c;
        if ($eqeq(basename1, ".")) {
          continue;
        };
        if ((($eqeq(basename1, "..") || ($truthy(basename_list2['$empty?']()))) || ($neqeq(basename_list2.$first(), "..")))) {
          
          prefix1 = $rb_plus(prefix1, basename1);
          break;;
        };
        index_list2.$shift();
        basename_list2.$shift();
      };
      r1 = self.$chop_basename(prefix1);
      if (($not(r1) && ($truthy($regexp([$$('SEPARATOR_PAT')])['$=~']($$('File').$basename(prefix1)))))) {
        while ($truthy(($truthy(($ret_or_1 = basename_list2['$empty?']()['$!']())) ? (basename_list2.$first()['$==']("..")) : ($ret_or_1)))) {
          
          index_list2.$shift();
          basename_list2.$shift();
        }
      };
      if ($not(basename_list2['$empty?']())) {
        
        suffix2 = path2['$[]'](Opal.Range.$new(index_list2.$first(), -1, false));
        if ($truthy(r1)) {
          return $$('File').$join(prefix1, suffix2)
        } else {
          return $rb_plus(prefix1, suffix2)
        };
      } else if ($truthy(r1)) {
        return prefix1
      } else {
        return $$('File').$dirname(prefix1)
      };
    }, 2);
    
    $def(self, '$join', function $$join($a) {try {

      var $post_args, args, self = this, result = nil;

      
      
      $post_args = Opal.slice.call(arguments);
      
      args = $post_args;;
      if ($truthy(args['$empty?']())) {
        return self
      };
      result = args.$pop();
      if (!$eqeqeq($$('Pathname'), result)) {
        result = $$('Pathname').$new(result)
      };
      if ($truthy(result['$absolute?']())) {
        return result
      };
      $send(args, 'reverse_each', [], function $$6(arg){
        
        
        if (arg == null) arg = nil;;
        if (!$eqeqeq($$('Pathname'), arg)) {
          arg = $$('Pathname').$new(arg)
        };
        result = $rb_plus(arg, result);
        if ($truthy(result['$absolute?']())) {
          Opal.ret(result)
        } else {
          return nil
        };}, 1);
      return $rb_plus(self, result);
      } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
    }, -1);
    
    $def(self, '$split', function $$split() {
      var self = this;

      return [self.$dirname(), self.$basename()]
    }, 0);
    
    $def(self, '$dirname', function $$dirname() {
      var self = this;

      return $$('Pathname').$new($$('File').$dirname(self.path))
    }, 0);
    
    $def(self, '$basename', function $$basename() {
      var self = this;

      return $$('Pathname').$new($$('File').$basename(self.path))
    }, 0);
    
    $def(self, '$directory?', function $Pathname_directory$ques$7() {
      var self = this;

      return $$('File')['$directory?'](self.path)
    }, 0);
    
    $def(self, '$extname', function $$extname() {
      var self = this;

      return $$('File').$extname(self.path)
    }, 0);
    
    $def(self, '$<=>', function $Pathname_$lt_eq_gt$8(other) {
      var self = this;

      return self.$path()['$<=>'](other.$path())
    }, 1);
    $const_set($nesting[0], 'SAME_PATHS', ($truthy($$$($$('File'), 'FNM_SYSCASE')['$nonzero?']()) ? ($send(self, 'proc', [], function $Pathname$9(a, b){
      
      
      if (a == null) a = nil;;
      
      if (b == null) b = nil;;
      return a.$casecmp(b)['$=='](0);}, 2)) : ($send(self, 'proc', [], function $Pathname$10(a, b){
      
      
      if (a == null) a = nil;;
      
      if (b == null) b = nil;;
      return a['$=='](b);}, 2))));
    
    $def(self, '$relative_path_from', function $$relative_path_from(base_directory) {
      var $a, $b, $c, self = this, dest_directory = nil, dest_prefix = nil, dest_names = nil, r = nil, basename = nil, base_prefix = nil, base_names = nil, $ret_or_1 = nil, $ret_or_2 = nil, relpath_names = nil;

      
      dest_directory = self.$cleanpath().$to_s();
      base_directory = base_directory.$cleanpath().$to_s();
      dest_prefix = dest_directory;
      dest_names = [];
      while ($truthy((r = self.$chop_basename(dest_prefix)))) {
        
        $c = r, $b = $to_ary($c), (dest_prefix = ($b[0] == null ? nil : $b[0])), (basename = ($b[1] == null ? nil : $b[1])), $c;
        if ($neqeq(basename, ".")) {
          dest_names.$unshift(basename)
        };
      };
      base_prefix = base_directory;
      base_names = [];
      while ($truthy((r = self.$chop_basename(base_prefix)))) {
        
        $c = r, $b = $to_ary($c), (base_prefix = ($b[0] == null ? nil : $b[0])), (basename = ($b[1] == null ? nil : $b[1])), $c;
        if ($neqeq(basename, ".")) {
          base_names.$unshift(basename)
        };
      };
      if (!$truthy($$('SAME_PATHS')['$[]'](dest_prefix, base_prefix))) {
        self.$raise($$('ArgumentError'), "different prefix: " + (dest_prefix.$inspect()) + " and " + (base_directory.$inspect()))
      };
      while ($truthy(($truthy(($ret_or_1 = ($truthy(($ret_or_2 = dest_names['$empty?']()['$!']())) ? (base_names['$empty?']()['$!']()) : ($ret_or_2)))) ? ($$('SAME_PATHS')['$[]'](dest_names.$first(), base_names.$first())) : ($ret_or_1)))) {
        
        dest_names.$shift();
        base_names.$shift();
      };
      if ($truthy(base_names['$include?'](".."))) {
        self.$raise($$('ArgumentError'), "base_directory has ..: " + (base_directory.$inspect()))
      };
      base_names.$fill("..");
      relpath_names = $rb_plus(base_names, dest_names);
      if ($truthy(relpath_names['$empty?']())) {
        return $$('Pathname').$new(".")
      } else {
        return $$('Pathname').$new($send($$('File'), 'join', $to_a(relpath_names)))
      };
    }, 1);
    
    $def(self, '$entries', function $$entries() {
      var self = this;

      return $send($$('Dir').$entries(self.path), 'map', [], function $$11(f){var self = $$11.$$s == null ? this : $$11.$$s;

        
        
        if (f == null) f = nil;;
        return self.$class().$new(f);}, {$$arity: 1, $$s: self})
    }, 0);
    $alias(self, "===", "==");
    $alias(self, "eql?", "==");
    $alias(self, "to_s", "to_path");
    return $alias(self, "to_str", "to_path");
  })($nesting[0], null, $nesting);
  return (function($base, $parent_nesting) {
    var self = $module($base, 'Kernel');

    var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting);

    return $def(self, '$Pathname', function $$Pathname(path) {
      
      return $$('Pathname').$new(path)
    }, 1)
  })($nesting[0], $nesting);
};

Opal.modules["nodejs/pathname"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var self = Opal.top, $nesting = [], nil = Opal.nil, $klass = Opal.klass, $def = Opal.def;

  Opal.add_stubs('require,include,to_str,!,absolute?');
  
  self.$require("pathname");
  return (function($base, $super, $parent_nesting) {
    var self = $klass($base, $super, 'Pathname');

    var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting), $proto = self.$$prototype;
    if (self.__path__ == null) self.__path__ = nil;

    $proto.path = nil;
    
    self.$include($$('Comparable'));
    self.__path__ = __path__;
    
    $def(self, '$absolute?', function $Pathname_absolute$ques$1() {
      var self = this;

      return __path__.isAbsolute(self.path.$to_str())
    }, 0);
    
    $def(self, '$relative?', function $Pathname_relative$ques$2() {
      var self = this;

      return self['$absolute?']()['$!']()
    }, 0);
    return $def(self, '$to_path', function $$to_path() {
      var self = this;

      return self.path
    }, 0);
  })($nesting[0], null, $nesting);
};

Opal.modules["nodejs/env"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var $nesting = [], $$ = Opal.$r($nesting), nil = Opal.nil, $const_set = Opal.const_set, $def = Opal.def, $truthy = Opal.truthy, $send = Opal.send, $alias = Opal.alias;

  Opal.add_stubs('new,to_s,key?,[],raise,to_h,keys,merge');
  
  $const_set($nesting[0], 'ENV', $$('Object').$new());
  return (function(self, $parent_nesting) {
    var $nesting = [self].concat($parent_nesting), $$ = Opal.$r($nesting);

    
    
    $def(self, '$[]', function $$$1(name) {
      
      return process.env[name] || nil
    }, 1);
    
    $def(self, '$[]=', function $$$eq$2(name, value) {
      
      return process.env[name.$to_s()] = value.$to_s()
    }, 2);
    
    $def(self, '$key?', function $key$ques$3(name) {
      
      return process.env.hasOwnProperty(name)
    }, 1);
    
    $def(self, '$empty?', function $empty$ques$4() {
      
      return Object.keys(process.env).length === 0;
    }, 0);
    
    $def(self, '$keys', function $$keys() {
      
      return Object.keys(process.env);
    }, 0);
    
    $def(self, '$delete', function $delete$5(name) {
      
      
      var value = process.env[name] || nil;
      delete process.env[name];
      return value;
    
    }, 1);
    
    $def(self, '$fetch', function $$fetch(key, default_value) {
      var block = $$fetch.$$p || nil, self = this;

      delete $$fetch.$$p;
      
      ;
      ;
      if ($truthy(self['$key?'](key))) {
        return self['$[]'](key)
      };
      if ((block !== nil)) {
        return Opal.yield1(block, key)
      };
      if (!$truthy(typeof(default_value) === 'undefined')) {
        return default_value
      };
      return self.$raise($$('KeyError'), "key not found");
    }, -2);
    
    $def(self, '$to_s', function $$to_s() {
      
      return "ENV"
    }, 0);
    
    $def(self, '$to_h', function $$to_h() {
      var self = this;

      return $send(self.$keys(), 'to_h', [], function $$6(k){var self = $$6.$$s == null ? this : $$6.$$s;

        
        
        if (k == null) k = nil;;
        return [k, self['$[]'](k)];}, {$$arity: 1, $$s: self})
    }, 0);
    
    $def(self, '$merge', function $$merge(keys) {
      var self = this;

      return self.$to_h().$merge(keys)
    }, 1);
    $alias(self, "has_key?", "key?");
    $alias(self, "include?", "key?");
    $alias(self, "inspect", "to_s");
    $alias(self, "member?", "key?");
    return $alias(self, "to_hash", "to_h");
  })(Opal.get_singleton_class($$('ENV')), $nesting);
};

Opal.modules["nodejs"] = function(Opal) {/* Generated by Opal 1.4.0 */
  var self = Opal.top, $nesting = [], nil = Opal.nil, $module = Opal.module;

  Opal.add_stubs('require');
  
  $module($nesting[0], 'NodeJS');
  self.$require("nodejs/file");
  self.$require("nodejs/dir");
  self.$require("nodejs/io");
  self.$require("nodejs/argf");
  self.$require("nodejs/open-uri");
  self.$require("nodejs/pathname");
  return self.$require("nodejs/env");
};

