import { sha256_asm } from './sha256.asm';
import { hash_finish, hash_process, hash_reset } from '../hash';
import { _heap_init } from '../../utils';

export var _sha256_block_size = 64;
export var _sha256_hash_size = 32;

export function sha256_constructor(options) {
  options = options || {};

  this.heap = _heap_init(Uint8Array, options.heap);
  this.asm = options.asm || sha256_asm({ Uint8Array: Uint8Array }, null, this.heap.buffer);

  this.BLOCK_SIZE = _sha256_block_size;
  this.HASH_SIZE = _sha256_hash_size;

  this.reset();
}

sha256_constructor.BLOCK_SIZE = _sha256_block_size;
sha256_constructor.HASH_SIZE = _sha256_hash_size;
sha256_constructor.NAME = 'sha256';

var sha256_prototype = sha256_constructor.prototype;
sha256_prototype.reset = hash_reset;
sha256_prototype.process = hash_process;
sha256_prototype.finish = hash_finish;

var sha256_instance = null;

export function get_sha256_instance() {
  if (sha256_instance === null) sha256_instance = new sha256_constructor({ heapSize: 0x100000 });
  return sha256_instance;
}
