'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _mapValuesLimit = require('./mapValuesLimit');

var _mapValuesLimit2 = _interopRequireDefault(_mapValuesLimit);

var _doLimit = require('./internal/doLimit');

var _doLimit2 = _interopRequireDefault(_doLimit);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The same as `mapValues` but runs only a single async operation at a time.
 *
 * @name mapValuesSeries
 * @static
 * @memberOf async
 * @see async.mapValues
 * @category Collection
 * @param {Object} obj - A collection to iterate over.
 * @param {Function} iteratee - A function to apply to each value in `obj`.
 * The iteratee is passed a `callback(err, transformed)` which must be called
 * once it has completed with an error (which can be `null`) and a
 * transformed value. Invoked with (value, key, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Result is an object of the
 * transformed values from the `obj`. Invoked with (err, result).
 */
exports.default = (0, _doLimit2.default)(_mapValuesLimit2.default, 1);
module.exports = exports['default'];