"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilePropTypes = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var prop_types_1 = __importDefault(require("prop-types"));
exports.FilePropTypes = {
    /**
     * `name` prop describes the filename for which should be used when generating the file. If none is specified the filename for the template are used.
     */
    name: prop_types_1.default.string,
    /**
     * `permissions` prop describes the permissions the file should be created with. This is interpreted as an octal number such as 0o777
     */
    permissions: prop_types_1.default.number,
};
/**
 * Component is used to describe to the generator that you want a file to be created and rendered based on the defined children.
 *
 * @component
 * @example
 * const name = "test.js"
 * const permissions = 0o777
 * return (
 *   <File name={name} permissions={permissions}>Test</File>
 * )
 */
var File = function (_a) {
    var children = _a.children;
    return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: children }, void 0);
};
File.propTypes = __assign({}, exports.FilePropTypes);
exports.default = File;
//# sourceMappingURL=File.js.map