import PropTypes from 'prop-types';
import { IndentationTypes } from "../utils";
import { FunctionComponent } from "../types";
export interface IndentProps {
    /**
     * `size` prop expects a string which format should be a number which represent the number of `type`'s to indent each content. Default to no indentation.
     */
    size?: number;
    /**
     * `type` prop expects a string, you can use the `IndentationTypes` enum, as either `TABS` or `SPACES`. The `type` defaults to `SPACES`.
     */
    type?: IndentationTypes;
}
export declare const IndentPropTypes: {
    /**
     * `size` prop expects a string which format should be a number which represent the number of `type`'s to indent each content. Default to no indentation.
     */
    size: PropTypes.Requireable<number>;
    /**
     * `type` prop expects a string, you can use the `IndentationTypes` enum, as either `TABS` or `SPACES`. The `type` defaults to `SPACES`.
     */
    type: PropTypes.Requireable<IndentationTypes>;
};
/**
 * Component is for wrapping multiple components and apply an indentation on those.
 *
 * It supports any form of nested components as well, meaning you can have as many nested `Indent` components as you would like.
 *
 * @component
 * @example
 * const size = 4
 * const type = IndentationTypes.SPACES
 * return (
 *   <Indent size={size} type={type}>test</Indent>
 * )
 */
declare const Indent: FunctionComponent<IndentProps>;
export default Indent;
