"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndentPropTypes = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var prop_types_1 = __importDefault(require("prop-types"));
var utils_1 = require("../utils");
exports.IndentPropTypes = {
    /**
     * `size` prop expects a string which format should be a number which represent the number of `type`'s to indent each content. Default to no indentation.
     */
    size: prop_types_1.default.number,
    /**
     * `type` prop expects a string, you can use the `IndentationTypes` enum, as either `TABS` or `SPACES`. The `type` defaults to `SPACES`.
     */
    type: prop_types_1.default.oneOf(Object.values(utils_1.IndentationTypes)),
};
/**
 * Component is for wrapping multiple components and apply an indentation on those.
 *
 * It supports any form of nested components as well, meaning you can have as many nested `Indent` components as you would like.
 *
 * @component
 * @example
 * const size = 4
 * const type = IndentationTypes.SPACES
 * return (
 *   <Indent size={size} type={type}>test</Indent>
 * )
 */
var Indent = function (_a) {
    var _b = _a.size, size = _b === void 0 ? 0 : _b, _c = _a.type, type = _c === void 0 ? utils_1.IndentationTypes.SPACES : _c, childrenContent = _a.childrenContent;
    return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: utils_1.withIndendation(childrenContent, size, type) }, void 0);
};
Indent.propTypes = __assign({}, exports.IndentPropTypes);
exports.default = Indent;
//# sourceMappingURL=Indent.js.map