import PropTypes from 'prop-types';
import { IndentationTypes } from "../utils";
import { FunctionComponent } from "../types";
export interface TextProps {
    /**
     * `indent` prop represents the number of `type`'s to indent each content. Default to no indentation.
     */
    indent?: number;
    /**
     * `type` prop expects a string, you can use the `IndentationTypes` enum, as either `TABS` or `SPACES`. The `type` defaults to `SPACES`.
     */
    type?: IndentationTypes;
    /**
     * `newLines` prop represents the number of appended new lines. Default to one new line.
     */
    newLines?: number;
}
export declare const TextPropTypes: {
    /**
     * `size` prop expects a string which format should be a number which represent the number of `type`'s to indent each content. Default to no indentation.
     */
    size: PropTypes.Requireable<number>;
    /**
     * `type` prop expects a string, you can use the `IndentationTypes` enum, as either `TABS` or `SPACES`. The `type` defaults to `SPACES`.
     */
    type: PropTypes.Requireable<IndentationTypes>;
    /**
     * `newLines` prop represents the number of appended new lines. Default to one new line.
     */
    newLines: PropTypes.Requireable<number>;
};
/**
 * Component is for defining a group of text which should be rendered on the same line.
 *
 * @component
 * @example
 * const indent = 4
 * const type = IndentationTypes.SPACES
 * const newLines = 2
 * return (
 *   <Text indent={size} type={type} newLines={newLines}>Test</Text>
 * )
 */
declare const Text: FunctionComponent<TextProps>;
export default Text;
